"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),otplib_1=require("otplib"),save_post_1=require("./save.post");exports.metadata={summary:"Verifies the OTP",operationId:"verifyOTP",tags:["Auth"],description:"Verifies the OTP and saves it",requiresAuth:!0,logModule:"2FA",logTitle:"Verify 2FA setup",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{otp:{type:"string",description:"OTP to verify"},secret:{type:"string",description:"Generated OTP secret"},type:{type:"string",enum:["EMAIL","SMS","APP"],description:"Type of 2FA"}},required:["otp","secret","type"]}}}},responses:{200:{description:"OTP verified and saved successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},400:{description:"Invalid request"},401:{description:"Unauthorized"}}};exports.default=async e=>{const{body:t,user:r,ctx:s}=e;try{null==s||s.step("Validating user authentication");if(!r){null==s||s.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"unauthorized"})}null==s||s.step("Validating OTP input");if(!t.otp||!t.secret||!t.type){null==s||s.fail("Missing required fields");throw(0,error_1.createError)({statusCode:400,message:"OTP, secret, and type are required"})}null==s||s.step("Verifying OTP");if(!otplib_1.authenticator.verify({token:t.otp,secret:t.secret})){null==s||s.fail("Invalid OTP");throw(0,error_1.createError)({statusCode:401,message:"Invalid OTP"})}null==s||s.step("Saving 2FA settings");const e=await(0,save_post_1.saveOrUpdateOTP)(r.id,t.secret,t.type);null==s||s.success(`2FA setup completed for ${t.type}`);return e}catch(e){null==s||s.fail(e.message||"OTP verification failed");throw e}};