"use strict";async function handleSms2FA(e,t,r,a){null==a||a.step("Checking SMS 2FA availability");const s=cache_1.CacheManager.getInstance();if(!("true"===await s.getSetting("twoFactorSmsStatus")))throw(0,error_1.createError)({statusCode:400,message:"SMS 2FA is not enabled"});if(!process.env.APP_TWILIO_VERIFY_SERVICE_SID)throw(0,error_1.createError)({statusCode:500,message:"Service SID is not set"});if(!r)throw(0,error_1.createError)({statusCode:400,message:"Phone number is required for SMS"});null==a||a.step(`Saving phone number: ${r}`);try{await savePhoneQuery(e.id,r)}catch(e){throw(0,error_1.createError)({statusCode:500,message:e.message})}null==a||a.step("Generating and sending SMS OTP");const n=otplib_1.authenticator.generate(t);try{const e=(0,(await Promise.resolve().then(()=>__importStar(require("twilio")))).default)(constants_1.APP_TWILIO_ACCOUNT_SID,constants_1.APP_TWILIO_AUTH_TOKEN);await e.messages.create({body:`Your OTP code is: ${n}`,from:process.env.APP_TWILIO_PHONE_NUMBER,to:r})}catch(e){console_1.logger.error("AUTH","Error sending SMS OTP",e);throw(0,error_1.createError)({statusCode:500,message:e.message})}return{secret:t}}async function handleApp2FA(e,t,r){null==r||r.step("Checking APP 2FA availability");const a=cache_1.CacheManager.getInstance();if(!("true"===await a.getSetting("twoFactorAppStatus")))throw(0,error_1.createError)({statusCode:400,message:"App 2FA is not enabled"});if(!e.email)throw(0,error_1.createError)({statusCode:400,message:"Email is required for APP OTP"});null==r||r.step("Generating QR code for authenticator app");const s=otplib_1.authenticator.keyuri(e.email,constants_1.appName,t);return{secret:t,qrCode:await qrcode_1.default.toDataURL(s)}}async function handleEmail2FA(e,t,r){null==r||r.step("Checking email 2FA availability");const a=cache_1.CacheManager.getInstance();if(!("true"===await a.getSetting("twoFactorEmailStatus")))throw(0,error_1.createError)({statusCode:400,message:"Email 2FA is not enabled"});const s=e.email,n=otplib_1.authenticator.generate(t);null==r||r.step(`Sending OTP to email: ${s}`);try{await emails_1.emailQueue.add({emailData:{TO:s,FIRSTNAME:e.firstName,TOKEN:n},emailType:"OTPTokenVerification"})}catch(e){throw(0,error_1.createError)({statusCode:500,message:e.message})}return{secret:t}}async function savePhoneQuery(e,t){return await db_1.models.user.update({phone:t},{where:{id:e}})}var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,r,a){void 0===a&&(a=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}});Object.defineProperty(e,a,s)}:function(e,t,r,a){void 0===a&&(a=r);e[a]=t[r]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(){var e=function(t){e=Object.getOwnPropertyNames||function(e){var t=[];for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&(t[t.length]=r);return t};return e(t)};return function(t){if(t&&t.__esModule)return t;var r={};if(null!=t)for(var a=e(t),s=0;s<a.length;s++)"default"!==a[s]&&__createBinding(r,t,a[s]);__setModuleDefault(r,t);return r}}(),__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const constants_1=require("@b/utils/constants"),error_1=require("@b/utils/error"),db_1=require("@b/db"),console_1=require("@b/utils/console"),otplib_1=require("otplib"),qrcode_1=__importDefault(require("qrcode")),emails_1=require("@b/utils/emails"),utils_1=require("./utils"),cache_1=require("@b/utils/cache");exports.metadata={summary:"Generates an OTP secret",operationId:"generateOTPSecret",tags:["Auth"],description:"Generates an OTP secret for the user",requiresAuth:!0,logModule:"2FA",logTitle:"Generate 2FA secret",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{type:{type:"string",enum:["EMAIL","SMS","APP"],description:"Type of 2FA"},phoneNumber:{type:"string",description:"Phone number for SMS OTP"}},required:["type"]}}}},responses:{200:{description:"OTP secret generated successfully",content:{"application/json":{schema:{type:"object",properties:{secret:{type:"string",description:"Generated OTP secret"},qrCode:{type:"string",description:"QR code for APP OTP"}}}}}},400:{description:"Invalid request"},401:{description:"Unauthorized"}}};exports.default=async e=>{const{body:t,user:r,ctx:a}=e;try{null==a||a.step("Validating user authentication");if(!r){null==a||a.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"unauthorized"})}null==a||a.step("Looking up user record");const e=await(0,utils_1.getUserById)(r.id),{type:s,phoneNumber:n}=t;null==a||a.step("Validating 2FA type");if(!s){null==a||a.fail("2FA type is required");throw(0,error_1.createError)({statusCode:400,message:"2FA type is required"})}null==a||a.step("Generating OTP secret");otplib_1.authenticator.options={window:2};const o=otplib_1.authenticator.generateSecret();null==a||a.step(`Setting up ${s} 2FA`);let i;switch(s){case"SMS":i=await handleSms2FA(e,o,n,a);break;case"APP":i=await handleApp2FA(e,o,a);break;case"EMAIL":i=await handleEmail2FA(e,o,a);break;default:null==a||a.fail("Invalid 2FA type");throw(0,error_1.createError)({statusCode:400,message:"Invalid type or 2FA method not enabled"})}null==a||a.success(`${s} 2FA generated successfully`);return i}catch(e){null==a||a.fail(e.message||"Failed to generate OTP");throw e}};