"use strict";function adminError(e="System configuration error. Please contact administrator.",t){t?console_1.logger.error("ADMIN",e,t):console_1.logger.error("ADMIN",e);return new Error(e)}async function getProduct(e){if(e){const t=await db_1.models.extension.findOne({where:{productId:e}});if(!t)throw adminError();return t}try{const e=[`${rootPath}/package.json`,`${path_1.default.join(rootPath,"..")}/package.json`,`${process.cwd()}/package.json`,`${path_1.default.join(process.cwd(),"..")}/package.json`];let t=null,r="";for(const o of e)try{const e=await fs_1.promises.readFile(o,"utf8");t=JSON.parse(e);if(t&&(t.id||t.name)){r=o;break}}catch(e){continue}if(!t||!t.id)throw adminError("Could not find valid package.json with required fields");return{id:t.id||"35599184",productId:t.id||"35599184",name:t.name||"bicrypto",version:t.version||"5.0.0",description:t.description||"BiCrypto Trading Platform"}}catch(e){throw adminError("Could not read product information.",e)}}async function getBlockchain(e){const t=await db_1.models.ecosystemBlockchain.findOne({where:{productId:e}});if(!t)throw adminError();return t}async function fetchPublicIp(){try{return(await new Promise((e,t)=>{https_1.default.get("https://api.ipify.org?format=json",r=>{let o="";r.on("data",e=>{o+=e});r.on("end",()=>{e(JSON.parse(o))});r.on("error",e=>{t(e)})})})).ip}catch(e){console_1.logger.error("ADMIN",`Error fetching public IP: ${e.message}`);return null}}async function getPublicIp(){const e=Date.now();if(cachedIP&&lastFetched&&e-lastFetched<6e4)return cachedIP;cachedIP=await fetchPublicIp();lastFetched=e;return cachedIP}async function callApi(e,t,r=null,o){try{const n=(0,license_1.getLicenseConfig)(),a=r?JSON.stringify(r):null,s={"Content-Type":"application/json","X-License-Secret":n.licenseSecret,"X-Site-URL":process.env.NEXT_PUBLIC_SITE_URL||"http://localhost:3000","X-Client-IP":await getPublicIp()||"127.0.0.1"};a&&(s["Content-Length"]=Buffer.byteLength(a).toString());const i=new URL(t),c="https:"===i.protocol,l=c?https_1.default:http_1.default,d={hostname:i.hostname,port:i.port||(c?443:80),path:i.pathname+i.search,method:e,headers:s};console_1.logger.debug("LICENSE_API",`${e} ${t}`);const u=await new Promise((e,r)=>{const n=l.request(d,t=>{const n=[],a=t.headers["content-type"]||"",s=a.includes("application/zip")||a.includes("application/octet-stream");console_1.logger.debug("LICENSE_API",`Response status: ${t.statusCode}, Content-Type: ${a}, isZip: ${s}`);if(200===t.statusCode){if(s){if(!o){r(adminError("Filename required for zip download."));return}const n=`${rootPath}/updates`,a=`${n}/${o}.zip`;fs_1.promises.mkdir(n,{recursive:!0}).then(()=>{const o=(0,fs_2.createWriteStream)(a);t.pipe(o);o.on("finish",()=>{console_1.logger.info("LICENSE_API",`ZIP file downloaded successfully to: ${a}`);e({status:!0,message:"Update file downloaded successfully",path:a})});o.on("error",e=>{r(adminError("Download error.",e))})}).catch(e=>{r(adminError("Directory error.",e))})}else{t.on("data",e=>{n.push(e)});t.on("end",()=>{try{const t=Buffer.concat(n).toString();console_1.logger.debug("LICENSE_API",`JSON response received (${t.length} bytes)`);const r=JSON.parse(t);e(r)}catch(e){r(new Error(`Invalid JSON response from server: ${Buffer.concat(n).toString().slice(0,200)}`))}})}t.on("error",e=>{r(new Error(`Response error: ${e.message}`))})}else{t.on("data",e=>{n.push(e)});t.on("end",()=>{let e=`HTTP ${t.statusCode}`;try{const t=JSON.parse(Buffer.concat(n).toString());e=t.message||t.error||t.reason||JSON.stringify(t)}catch(t){e=Buffer.concat(n).toString().slice(0,200)||e}r(new Error(`API Error (${t.statusCode}): ${e}`))})}});n.on("error",e=>{r(new Error(`Connection error: ${e.message}. Is the license server running at ${t}?`))});a&&n.write(a);n.end()});return u}catch(e){console_1.logger.error("LICENSE_API",`API call failed: ${e.message}`);throw e}}async function verifyLicense(e,t,r,o){const n=`${licFolderPath}/${e}.lic`;if(o&&verificationPeriodDays>0){const e=new Date;if(nextVerificationDate&&e<nextVerificationDate)return{status:!0,message:"Verified from cache"}}let a=null;try{const e=await fs_1.promises.readFile(n,"utf8");try{const t=JSON.parse(Buffer.from(e,"base64").toString("utf8"));a=t.purchaseCode||t.licenseKey||t.license_key}catch(t){a=e.trim()}}catch(e){a=t||null}if(!a)throw(0,error_1.createError)({statusCode:400,message:"No purchase code found. Please activate your license first."});const s=process.env.NEXT_PUBLIC_SITE_URL||"http://localhost:3000";let i;try{i=new URL(s).host}catch(e){i=s.replace(/^https?:\/\//,"").split("/")[0]}const{getCachedFingerprint:c}=await Promise.resolve().then(()=>__importStar(require("@b/utils/security/fingerprint"))),l=c(),d={purchaseCode:a,domain:i,fingerprint:l},u=(0,license_1.getLicenseConfig)();console_1.logger.info("LICENSE_API",`Verifying license - Domain: ${i}, Fingerprint: ${l?l.substring(0,16)+"...":"MISSING"}`);console_1.logger.debug("LICENSE_API",`Verify payload: ${JSON.stringify(d)}`);const p=await callApi("POST",`${u.apiUrl}/api/client/licenses/verify`,d);if(o&&verificationPeriodDays>0&&p.status){const e=new Date;nextVerificationDate=new Date;nextVerificationDate.setDate(e.getDate()+verificationPeriodDays)}if(!p.status){const e=p.reason||"License verification failed";throw(0,error_1.createError)({statusCode:400,message:e})}return p}async function activateLicense(e,t,r,o){var n;const a=process.env.NEXT_PUBLIC_SITE_URL||"http://localhost:3000";let s;try{s=new URL(a).host}catch(e){s=a.replace(/^https?:\/\//,"").split("/")[0]}const i=await getPublicIp()||"127.0.0.1",{getCachedFingerprint:c}=await Promise.resolve().then(()=>__importStar(require("@b/utils/security/fingerprint"))),l={purchaseCode:t,domain:s,ipAddress:i,hardwareFingerprint:c(),metadata:{productId:e,clientName:r,activatedVia:"admin-panel"}};o&&(l.notificationEmail=o);const d=(0,license_1.getLicenseConfig)();console_1.logger.info("LICENSE_API",`Activating license - Domain: ${s}, ProductId: ${e}`);console_1.logger.debug("LICENSE_API",`Activation payload: ${JSON.stringify(l)}`);const u=await callApi("POST",`${d.apiUrl}/api/client/licenses/activate`,l);if(!u.status){const e=u.reason||u.message||"License activation failed";throw(0,error_1.createError)({statusCode:400,message:e})}const p=`${licFolderPath}/${e}.lic`,f=u,g={purchaseCode:t,productId:e,clientName:r,domain:s,activatedAt:(new Date).toISOString(),...(null===(n=f.data)||void 0===n?void 0:n.license)||f.license||f.data||{}},h=Buffer.from(JSON.stringify(g)).toString("base64");await fs_1.promises.mkdir(licFolderPath,{recursive:!0});await fs_1.promises.writeFile(p,h);return{status:!0,message:u.message||"License activated successfully",data:u.data}}async function checkLatestVersion(){return{status:!1,message:"Version check not available via this endpoint",version:null}}function compareVersions(e,t){const r=e.split(".").map(e=>parseInt(e,10)||0),o=t.split(".").map(e=>parseInt(e,10)||0),n=Math.max(r.length,o.length);for(let e=0;e<n;e++){const t=r[e]||0,n=o[e]||0;if(t<n)return-1;if(t>n)return 1}return 0}async function checkUpdate(e,t){var r,o,n;const a=(0,license_1.getLicenseConfig)(),s=`${licFolderPath}/${e}.lic`;let i=null;try{const e=await fs_1.promises.readFile(s,"utf8");try{const t=JSON.parse(Buffer.from(e,"base64").toString("utf8"));i=t.purchaseCode||t.licenseKey}catch(t){i=e.trim()}}catch(e){return{status:!1,message:"License required to check for updates",updateAvailable:!1,update_id:"",version:t,changelog:null,pendingUpdates:[],latestVersion:t,isSequential:!0}}if(!i)return{status:!1,message:"No purchase code found",updateAvailable:!1,update_id:"",version:t,changelog:null,pendingUpdates:[],latestVersion:t,isSequential:!0};const{getCachedFingerprint:c}=await Promise.resolve().then(()=>__importStar(require("@b/utils/security/fingerprint"))),l=c(),d={purchaseCode:i,productId:e,currentVersion:t,fingerprint:l};try{const e=await callApi("POST",`${a.apiUrl}/api/client/updates/check`,d);if(e.status){const a=e,s=a.pendingUpdates||[],i=a.latestVersion||(null===(r=e.data)||void 0===r?void 0:r.latestVersion)||t,c=a.nextUpdate||null;let l=[];if(s.length>0)l=s.map(e=>({version:e.version,updateId:e.updateId||e.update_id||e.version,changelog:e.changelog||null}));else if(e.data){const r=e.data.availableVersions||e.data.versions||[];r.length>0?l=r.filter(e=>compareVersions("string"==typeof e?e:e.version,t)>0).map(e=>({version:"string"==typeof e?e:e.version,updateId:"string"==typeof e?e:e.updateId||e.update_id||e.version,changelog:"string"==typeof e?null:e.changelog})).sort((e,t)=>compareVersions(e.version,t.version)):e.data.updateAvailable&&i!==t&&(l=[{version:i,updateId:e.data.updateId||i,changelog:e.data.changelog||null}])}const d=c||(l.length>0?l[0]:null);return{status:null!==d,message:d?l.length>1?`Update available: ${d.version} (${l.length} updates pending, must update sequentially)`:`Update available: ${d.version}`:"You have the latest version of the product.",updateAvailable:null!==d,update_id:(null==d?void 0:d.updateId)||"",version:(null==d?void 0:d.version)||t,changelog:(null==d?void 0:d.changelog)||null,pendingUpdates:l,latestVersion:i,isSequential:null===(o=a.isSequential)||void 0===o||o,totalPendingCount:null!==(n=a.totalPendingCount)&&void 0!==n?n:l.length}}return{status:!1,message:"You have the latest version of the product.",updateAvailable:!1,update_id:"",version:t,changelog:null,pendingUpdates:[],latestVersion:t,isSequential:!0}}catch(r){console_1.logger.warn("ADMIN",`Update check failed for product ${e}: ${r.message}`);return{status:!1,message:"You have the latest version of the product.",updateAvailable:!1,update_id:"",version:t,changelog:null,pendingUpdates:[],latestVersion:t,isSequential:!0}}}async function downloadUpdate(e,t,r,o,n){if(!(e&&t&&r&&o))throw adminError();const a=`${licFolderPath}/${e}.lic`;let s,i;try{s=await fs_1.promises.readFile(a,"utf8")}catch(e){throw adminError()}try{const e=JSON.parse(Buffer.from(s,"base64").toString("utf8"));i=e.purchaseCode||e.licenseKey}catch(e){i=s.trim()}const{getCachedFingerprint:c}=await Promise.resolve().then(()=>__importStar(require("@b/utils/security/fingerprint"))),l=c(),d=(0,license_1.getLicenseConfig)(),u={purchaseCode:i,productId:e,updateId:t||void 0,version:r||void 0,fingerprint:l};console_1.logger.info("LICENSE_API",`Downloading update: product=${o}, version=${r}, updateId=${t}`);const p=await callApi("POST",`${d.apiUrl}/api/client/updates/download`,u,`${o}-${r}`);console_1.logger.info("LICENSE_API",`Download response: status=${p.status}, path=${p.path}, message=${p.message}`);if(!p.status||!p.path){console_1.logger.error("LICENSE_API",`Download failed - response: ${JSON.stringify(p)}`);throw adminError("Update download failed.")}try{console_1.logger.info("UPDATE",`Extracting update to: ${rootPath}`);const t=unzip(p.path,rootPath);if(!t.success){console_1.logger.error("UPDATE",`Extraction failed: ${t.message}`);try{await fs_1.promises.unlink(p.path);console_1.logger.info("UPDATE","ZIP file cleaned up after failed extraction")}catch(e){}throw adminError(`Update extraction failed: ${t.message}`)}console_1.logger.info("UPDATE",`Extraction successful: ${t.extractedFiles.length} files updated`);if("extension"===n)try{await(0,system_1.updateExtensionQuery)(e,r);console_1.logger.info("UPDATE",`Extension ${e} version updated to ${r}`)}catch(e){throw adminError("Extension update failed.",e)}else if("blockchain"===n)try{await(0,system_1.updateBlockchainQuery)(e,r);console_1.logger.info("UPDATE",`Blockchain ${e} version updated to ${r}`)}catch(e){throw adminError("Blockchain update failed.",e)}else if("exchange"===n)try{await(0,system_1.updateExchangeQuery)(e,r);console_1.logger.info("UPDATE",`Exchange ${e} version updated to ${r}`)}catch(e){throw adminError("Exchange update failed.",e)}await fs_1.promises.unlink(p.path);console_1.logger.info("UPDATE","ZIP file cleaned up successfully");return{message:`Update downloaded and extracted successfully. ${t.extractedFiles.length} files updated.`,status:!0,data:{filesUpdated:t.extractedFiles.length,version:r}}}catch(e){console_1.logger.error("UPDATE",`Update extraction failed: ${e.message}`);if(e.message&&!e.message.includes("Update extraction failed"))throw adminError(`Update extraction failed: ${e.message}`,e);throw e}}async function fetchAllProductsUpdates(){const e=(0,license_1.getLicenseConfig)(),t=e.mainProductId,r=`${licFolderPath}/${t}.lic`;let o=null;try{const e=await fs_1.promises.readFile(r,"utf8");try{const t=JSON.parse(Buffer.from(e,"base64").toString("utf8"));o=t.purchaseCode||t.licenseKey}catch(t){o=e.trim()}}catch(e){console_1.logger.warn("ADMIN","No main product license found for batch update check");return{status:!0,message:"No license for batch check",products:[]}}if(!o)return{status:!0,message:"No purchase code found",products:[]};try{const[r,n,a]=await Promise.all([db_1.models.extension.findAll({attributes:["productId","version"]}),db_1.models.ecosystemBlockchain?db_1.models.ecosystemBlockchain.findAll({attributes:["productId","version"]}):Promise.resolve([]),db_1.models.exchange.findAll({attributes:["productId","version"]})]),s=[],i=await getProduct();s.push({productId:t,currentVersion:i.version||"5.0.0"});for(const e of r)e.productId&&s.push({productId:e.productId,currentVersion:e.version||"0.0.1"});for(const e of n)e.productId&&s.push({productId:e.productId,currentVersion:e.version||"0.0.1"});for(const e of a)e.productId&&s.push({productId:e.productId,currentVersion:e.version||"0.0.1"});const c={purchaseCode:o,products:s},l=await callApi("POST",`${e.apiUrl}/api/client/updates/batch`,c);if(l.status&&l.products){for(const e of l.products){const t=e.product_id||e.productId,o=e.current_version||e.currentVersion,s=e.latest_version||e.latestVersion,i=e.update_available||e.updateAvailable;if("0.0.1"===o&&s&&i){if(await fs_1.promises.access(`${licFolderPath}/${t}.lic`).then(()=>!0).catch(()=>!1)){if(n.find(e=>e.productId===t)){await db_1.models.ecosystemBlockchain.update({version:s},{where:{productId:t}});e.current_version=s;e.currentVersion=s;e.update_available=!1;e.updateAvailable=!1;e.summary="You have the latest version";console_1.logger.info("ADMIN",`Synced blockchain ${t} version to ${s}`)}if(r.find(e=>e.productId===t)){await db_1.models.extension.update({version:s},{where:{productId:t}});e.current_version=s;e.currentVersion=s;e.update_available=!1;e.updateAvailable=!1;e.summary="You have the latest version";console_1.logger.info("ADMIN",`Synced extension ${t} version to ${s}`)}if(a.find(e=>e.productId===t)){await db_1.models.exchange.update({version:s},{where:{productId:t}});e.current_version=s;e.currentVersion=s;e.update_available=!1;e.updateAvailable=!1;e.summary="You have the latest version";console_1.logger.info("ADMIN",`Synced exchange ${t} version to ${s}`)}}}}return{status:!0,message:"Batch update check completed",products:l.products}}return{status:!0,message:"No updates available",products:[]}}catch(e){console_1.logger.warn("ADMIN",`Batch update check failed: ${e.message}`);return{status:!0,message:"Batch check unavailable",products:[]}}}var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,r,o){void 0===o&&(o=r);var n=Object.getOwnPropertyDescriptor(t,r);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[r]}});Object.defineProperty(e,o,n)}:function(e,t,r,o){void 0===o&&(o=r);e[o]=t[r]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(){var e=function(t){e=Object.getOwnPropertyNames||function(e){var t=[];for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&(t[t.length]=r);return t};return e(t)};return function(t){if(t&&t.__esModule)return t;var r={};if(null!=t)for(var o=e(t),n=0;n<o.length;n++)"default"!==o[n]&&__createBinding(r,t,o[n]);__setModuleDefault(r,t);return r}}(),__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.getProduct=getProduct;exports.getBlockchain=getBlockchain;exports.fetchPublicIp=fetchPublicIp;exports.getPublicIp=getPublicIp;exports.callApi=callApi;exports.verifyLicense=verifyLicense;exports.activateLicense=activateLicense;exports.checkLatestVersion=checkLatestVersion;exports.checkUpdate=checkUpdate;exports.downloadUpdate=downloadUpdate;exports.fetchAllProductsUpdates=fetchAllProductsUpdates;const https_1=__importDefault(require("https")),http_1=__importDefault(require("http")),adm_zip_1=__importDefault(require("adm-zip")),fs_1=require("fs"),fs_2=require("fs"),system_1=require("../../../utils/system"),db_1=require("@b/db"),path_1=__importDefault(require("path")),license_1=require("@b/config/license"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error");let cachedIP=null,lastFetched=null,nextVerificationDate=null;const verificationPeriodDays=3,rootPath=(()=>{const e=process.cwd();return e.endsWith("/backend")||e.endsWith("\\backend")?path_1.default.join(e,".."):e})(),licFolderPath=`${rootPath}/lic`,unzip=(e,t)=>{const r=new adm_zip_1.default(e),o=r.getEntries(),n=[],a=[];console_1.logger.info("UPDATE",`Starting extraction of ${o.length} entries from ${path_1.default.basename(e)} to ${t}`);const s=o.filter(e=>!e.isDirectory);if(0===s.length){console_1.logger.warn("UPDATE","ZIP file contains no extractable files");return{success:!1,extractedFiles:[],failedFiles:[],totalFiles:0,message:"ZIP file contains no extractable files"}}for(const e of o)try{const o=e.entryName;if(e.isDirectory)continue;const i=path_1.default.join(t,o),c=path_1.default.dirname(i);try{require("fs").existsSync(c)||require("fs").mkdirSync(c,{recursive:!0})}catch(e){console_1.logger.warn("UPDATE",`Failed to create directory ${c}: ${e.message}`);a.push(o);continue}try{r.extractEntryTo(e,t,!0,!0);n.push(o);n.length%50==0&&console_1.logger.info("UPDATE",`Extracted ${n.length}/${s.length} files...`)}catch(e){console_1.logger.warn("UPDATE",`Failed to extract ${o}: ${e.message}`);a.push(o)}}catch(t){console_1.logger.error("UPDATE",`Error processing entry: ${t.message}`);a.push(e.entryName)}const i=0===a.length&&n.length>0;console_1.logger.info("UPDATE",`Extraction complete: ${n.length} files extracted, ${a.length} failed`);a.length>0&&console_1.logger.warn("UPDATE",`Failed files: ${a.slice(0,10).join(", ")}${a.length>10?` ... and ${a.length-10} more`:""}`);if(n.length>0){const e=n.slice(0,5);console_1.logger.info("UPDATE",`Sample extracted files: ${e.join(", ")}`)}return{success:i,extractedFiles:n,failedFiles:a,totalFiles:s.length,message:i?`Successfully extracted ${n.length} files`:`Extraction completed with ${a.length} errors`}};