"use strict";function getFileSizeFromFilename(e){const o=e.match(/(\d+)x(\d+)/);return o?{width:parseInt(o[1]),height:parseInt(o[2])}:null}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),promises_1=__importDefault(require("fs/promises")),fs_1=__importDefault(require("fs")),path_1=__importDefault(require("path")),sharp_1=__importDefault(require("sharp"));exports.metadata={summary:"Updates logo files in /public/img/logo/ directory",operationId:"updateLogoFiles",tags:["Admin","Settings","Logo"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{logoType:{type:"string",description:"Type of logo (logo, darkLogo, fullLogo, etc.)"},file:{type:"string",description:"Base64 encoded file data"}},required:["logoType","file"]}}}},responses:{200:{description:"Logo updated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},logoUrl:{type:"string"}}}}}},400:{description:"Invalid logo type or file"},401:{description:"Unauthorized"},500:{description:"Internal server error"}},permission:"edit.settings",requiresAuth:!0,logModule:"ADMIN_SYS",logTitle:"Update logo"};const STRICT_LOGO_MAPPING={logo:{primaryFiles:["logo.png","logo.webp"],additionalFiles:["apple-icon-precomposed.png","apple-icon-precomposed.webp","apple-icon.png","apple-icon.webp","apple-touch-icon.png","apple-touch-icon.webp"],size:{width:96,height:96}},darkLogo:{primaryFiles:["logo-dark.png","logo-dark.webp"],additionalFiles:[],size:{width:96,height:96}},fullLogo:{primaryFiles:["logo-text.png","logo-text.webp"],additionalFiles:[],size:{width:350,height:75}},darkFullLogo:{primaryFiles:["logo-text-dark.png","logo-text-dark.webp"],additionalFiles:[],size:{width:350,height:75}},cardLogo:{primaryFiles:["android-chrome-256x256.png","android-chrome-256x256.webp"],additionalFiles:[],size:{width:256,height:256}},favicon16:{primaryFiles:["favicon-16x16.png","favicon-16x16.webp"],additionalFiles:[],size:{width:16,height:16}},favicon32:{primaryFiles:["favicon-32x32.png","favicon-32x32.webp"],additionalFiles:[],size:{width:32,height:32}},favicon96:{primaryFiles:["favicon-96x96.png","favicon-96x96.webp"],additionalFiles:[],size:{width:96,height:96}},appleIcon57:{primaryFiles:["apple-icon-57x57.png","apple-icon-57x57.webp"],additionalFiles:[],size:{width:57,height:57}},appleIcon60:{primaryFiles:["apple-icon-60x60.png","apple-icon-60x60.webp"],additionalFiles:[],size:{width:60,height:60}},appleIcon72:{primaryFiles:["apple-icon-72x72.png","apple-icon-72x72.webp"],additionalFiles:[],size:{width:72,height:72}},appleIcon76:{primaryFiles:["apple-icon-76x76.png","apple-icon-76x76.webp"],additionalFiles:[],size:{width:76,height:76}},appleIcon114:{primaryFiles:["apple-icon-114x114.png","apple-icon-114x114.webp"],additionalFiles:[],size:{width:114,height:114}},appleIcon120:{primaryFiles:["apple-icon-120x120.png","apple-icon-120x120.webp"],additionalFiles:[],size:{width:120,height:120}},appleIcon144:{primaryFiles:["apple-icon-144x144.png","apple-icon-144x144.webp"],additionalFiles:["android-icon-144x144.png","android-icon-144x144.webp","mstile-144x144.png","mstile-144x144.webp"],size:{width:144,height:144}},appleIcon152:{primaryFiles:["apple-icon-152x152.png","apple-icon-152x152.webp"],additionalFiles:[],size:{width:152,height:152}},appleIcon180:{primaryFiles:["apple-icon-180x180.png","apple-icon-180x180.webp"],additionalFiles:[],size:{width:180,height:180}},androidIcon192:{primaryFiles:["android-chrome-192x192.png","android-chrome-192x192.webp"],additionalFiles:["android-icon-192x192.png","android-icon-192x192.webp"],size:{width:192,height:192}},androidIcon256:{primaryFiles:["android-chrome-256x256.png","android-chrome-256x256.webp"],additionalFiles:["android-icon-256x256.png","android-icon-256x256.webp"],size:{width:256,height:256}},androidIcon384:{primaryFiles:["android-chrome-384x384.png","android-chrome-384x384.webp"],additionalFiles:["android-icon-384x384.png","android-icon-384x384.webp"],size:{width:384,height:384}},androidIcon512:{primaryFiles:["android-chrome-512x512.png","android-chrome-512x512.webp"],additionalFiles:["android-icon-512x512.png","android-icon-512x512.webp"],size:{width:512,height:512}},msIcon144:{primaryFiles:["ms-icon-144x144.png","ms-icon-144x144.webp"],additionalFiles:["mstile-150x150.png","mstile-150x150.webp"],size:{width:144,height:144}}};exports.default=async e=>{const{body:o,ctx:i}=e,{logoType:r,file:t}=o;null==i||i.step("Validating logo upload request");if(!r||!t)throw(0,error_1.createError)({statusCode:400,message:"Logo type and file are required"});const s=STRICT_LOGO_MAPPING[r];if(!s)throw(0,error_1.createError)({statusCode:400,message:`Invalid logo type: ${r}. Valid types: ${Object.keys(STRICT_LOGO_MAPPING).join(", ")}`});if(!t.startsWith("data:"))throw(0,error_1.createError)({statusCode:400,message:"Invalid file format"});try{null==i||i.step(`Processing logo upload for type: ${r}`);console_1.logger.debug("LOGO",`Processing logo upload for type: ${r}`);console_1.logger.debug("LOGO",`File size: ${t.length} characters`);const e="production"===process.env.NODE_ENV;let o;if(e){const e=[path_1.default.join(process.cwd(),"frontend","public","img","logo"),path_1.default.join(process.cwd(),"public","img","logo"),path_1.default.join(process.cwd(),"..","frontend","public","img","logo"),path_1.default.join(process.cwd(),"..","public","img","logo")];o=e[0];for(const i of e){const e=path_1.default.dirname(i);if(fs_1.default.existsSync(e)){o=i;break}}console_1.logger.debug("LOGO","Production mode detected");console_1.logger.debug("LOGO",`Current working directory: ${process.cwd()}`);console_1.logger.debug("LOGO",`Selected logo directory: ${o}`);console_1.logger.debug("LOGO",`Logo directory exists: ${fs_1.default.existsSync(o)}`);console_1.logger.debug("LOGO",`Parent directory exists: ${fs_1.default.existsSync(path_1.default.dirname(o))}`)}else o=path_1.default.join(process.cwd(),"..","frontend","public","img","logo");const l=t.split(",")[1];if(!l)throw(0,error_1.createError)({statusCode:400,message:"Invalid file data"});const a=Buffer.from(l,"base64");console_1.logger.debug("LOGO",`Buffer created, size: ${a.length} bytes`);let n=o,d=!1;if(e){const e=[o,path_1.default.join(process.cwd(),"public","img","logo"),path_1.default.join(process.cwd(),"..","frontend","public","img","logo"),path_1.default.join(process.cwd(),"..","public","img","logo")];for(const o of e)try{if(!fs_1.default.existsSync(o)){await promises_1.default.mkdir(o,{recursive:!0});console_1.logger.debug("LOGO",`Successfully created directory: ${o}`)}n=o;d=!0;break}catch(e){console_1.logger.error("LOGO",`Failed to create directory ${o}: ${e.message}`);continue}if(!d)throw(0,error_1.createError)({statusCode:500,message:"Failed to create logo directory in any of the attempted paths"})}else if(!fs_1.default.existsSync(n))try{await promises_1.default.mkdir(n,{recursive:!0});console_1.logger.debug("LOGO",`Created logo directory: ${n}`)}catch(e){console_1.logger.error("LOGO",`Failed to create logo directory: ${n}`,e);throw(0,error_1.createError)({statusCode:500,message:`Failed to create logo directory: ${e.message}`})}console_1.logger.debug("LOGO",`Using final logo directory: ${n}`);const p=[...s.primaryFiles,...s.additionalFiles];null==i||i.step(`Processing ${p.length} logo variants`);const c=[];for(const e of p){const o=path_1.default.join(n,e),i=e.endsWith(".webp"),r=getFileSizeFromFilename(e)||s.size;try{let t=(0,sharp_1.default)(a);t=t.resize(r.width,r.height,{fit:"inside",withoutEnlargement:!1});t=i?t.webp({quality:90}):t.png({compressionLevel:6});await t.toFile(o);c.push({filename:e,success:!0})}catch(o){console_1.logger.error("LOGO",`Failed to process file ${e}: ${o.message}`);c.push({filename:e,success:!1,error:o.message})}}const g=`/img/logo/${s.primaryFiles[0]}`,h=c.filter(e=>e.success).length,u=c.filter(e=>!e.success).length;u>0&&(null==i||i.warn(`${u} logo variants failed to process`));null==i||i.success(`Logo ${r} updated: ${h}/${c.length} files processed`);return{message:`Logo ${r} updated successfully. Processed ${h}/${c.length} files.`,logoUrl:g,results:c}}catch(e){console_1.logger.error("LOGO",`Failed to update logo ${r}`,e);console_1.logger.error("LOGO",`Error message: ${null==e?void 0:e.message}`);console_1.logger.debug("LOGO",`Error stack: ${null==e?void 0:e.stack}`);null==i||i.fail(`Failed to update logo ${r}: ${(null==e?void 0:e.message)||e}`);throw(0,error_1.createError)({statusCode:500,message:`Failed to update logo ${r}: ${(null==e?void 0:e.message)||e}`})}};