"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),cache_1=require("@b/utils/cache");exports.metadata={summary:"Updates application settings",operationId:"updateApplicationSettings",tags:["Admin","Settings"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{data:{type:"object",description:"Settings data to update"}}}}}},responses:{200:{description:"Settings updated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Confirmation message indicating successful update"}}}}}},401:{description:"Unauthorized, admin permission required"},500:{description:"Internal server error"}},permission:"edit.settings",requiresAuth:!0,logModule:"SETTINGS",logTitle:"Update application settings"};exports.default=async e=>{const{body:t,ctx:s}=e;null==s||s.step("Validating settings data");const n={};let i=0;Object.entries(t).forEach(([e,t])=>{if("settings"===e||"extensions"===e){i++;return}let s="";s=null===t||"null"===t||void 0===t?"":"object"==typeof t?JSON.stringify(t):String(t);n[e]=s});i>0&&(null==s||s.warn(`Skipped ${i} problematic setting keys`));const a=Object.keys(n).length;null==s||s.step(`Processing ${a} settings`);null==s||s.step("Loading existing settings");const c=(await db_1.models.settings.findAll()).map(e=>e.key);null==s||s.step("Applying settings updates");let r=0,l=0;const o=Object.entries(n).map(async([e,t])=>{if(c.includes(e)){r++;return db_1.models.settings.update({value:t},{where:{key:e}})}l++;return db_1.models.settings.create({key:e,value:t})});await Promise.all(o);l>0&&(null==s||s.step(`Created ${l} new settings`,"success"));r>0&&(null==s||s.step(`Updated ${r} existing settings`,"success"));null==s||s.step("Clearing settings cache");const p=cache_1.CacheManager.getInstance();await p.clearCache();null==s||s.success(`${a} settings saved successfully`);return{message:"Settings updated successfully"}};