"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const notification_1=require("@b/services/notification"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Test SMS Notification",description:"Send a test SMS notification to verify the SMS channel is configured correctly",operationId:"testSMSNotification",tags:["Admin","Notification","Testing"],requiresAuth:!0,permission:"access.notification.settings",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{userId:{type:"string",description:"User ID to send test notification to (defaults to current user)"},phone:{type:"string",description:"Override phone number for testing (E.164 format)"}}}}}},responses:{200:{description:"Test SMS sent successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},message:{type:"string"},notificationId:{type:"string"},delivered:{type:"boolean"}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse}};exports.default=async e=>{var t,i,s,n;const{body:o,user:r,ctx:c}=e;try{null===(t=null==c?void 0:c.step)||void 0===t||t.call(c,"Sending test SMS notification");const e=o.userId||(null==r?void 0:r.id);if(!e)throw new Error("User ID is required");const n=await notification_1.notificationService.send({userId:e,type:"SYSTEM",channels:["SMS"],data:{message:"Test SMS from notification service. If you received this, your SMS channel is working!",testMode:!0,timestamp:(new Date).toISOString(),...o.phone&&{overridePhone:o.phone}},priority:"NORMAL",idempotencyKey:`test-sms-${e}-${Date.now()}`});null===(i=null==c?void 0:c.success)||void 0===i||i.call(c,"Test SMS notification sent");const a=n.channelsFailed.includes("SMS"),d=a&&(null===(s=n.errors)||void 0===s?void 0:s.SMS)?n.errors.SMS:a?"SMS channel not configured or not registered":void 0;return{success:n.success&&!a,message:a?d||"Failed to send test SMS":"Test SMS sent successfully",notificationId:n.notificationId,delivered:n.channelsDelivered.includes("SMS"),channels:{delivered:n.channelsDelivered,failed:n.channelsFailed}}}catch(e){null===(n=null==c?void 0:c.fail)||void 0===n||n.call(c,e.message);throw e}};