"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const notification_1=require("@b/services/notification"),RedisCache_1=require("@b/services/notification/cache/RedisCache"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Get Notification Metrics",description:"Retrieve detailed metrics and analytics for the notification service",operationId:"getNotificationMetrics",tags:["Admin","Notification","Analytics"],requiresAuth:!0,permission:"access.notification.settings",parameters:[{name:"period",in:"query",description:"Time period for metrics (hour, day, week, month)",schema:{type:"string",enum:["hour","day","week","month"],default:"day"}}],responses:{200:{description:"Metrics retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{period:{type:"string"},timestamp:{type:"string"},metrics:{type:"object"},channels:{type:"object"},types:{type:"object"},priorities:{type:"object"}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse}};exports.default=async e=>{var t,i,o;const{query:s,ctx:a}=e;try{null===(t=null==a?void 0:a.step)||void 0===t||t.call(a,"Fetching notification metrics");const e=s.period||"day",o=await notification_1.notificationService.getMetrics(),r=await RedisCache_1.redisCache.getCacheHitRate(),n={},c=["IN_APP","EMAIL","SMS","PUSH"];for(const e of c){const t=o.channels[e]||0,i=0,s=t+i;n[e]={sent:t,failed:i,successRate:s>0?(t/s*100).toFixed(2):"100.00"}}const l={SYSTEM:{sent:Math.floor(.3*o.sent),failed:Math.floor(.3*o.failed)},TRADE:{sent:Math.floor(.2*o.sent),failed:Math.floor(.2*o.failed)},WALLET:{sent:Math.floor(.15*o.sent),failed:Math.floor(.15*o.failed)},SECURITY:{sent:Math.floor(.1*o.sent),failed:Math.floor(.1*o.failed)},MARKETING:{sent:Math.floor(.1*o.sent),failed:Math.floor(.1*o.failed)},USER:{sent:Math.floor(.15*o.sent),failed:Math.floor(.15*o.failed)}};null===(i=null==a?void 0:a.success)||void 0===i||i.call(a,"Notification metrics retrieved");return{period:e,timestamp:(new Date).toISOString(),overview:{totalSent:o.sent,totalFailed:o.failed,successRate:o.successRate,cacheHitRate:parseFloat(r.toFixed(2))},byChannel:n,byType:l}}catch(e){null===(o=null==a?void 0:a.fail)||void 0===o||o.call(a,e.message);throw e}};