"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const notification_1=require("@b/services/notification"),RedisCache_1=require("@b/services/notification/cache/RedisCache"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Notification Service Dashboard",description:"Get comprehensive overview of notification service status and metrics",operationId:"getNotificationDashboard",tags:["Admin","Notification","Dashboard"],requiresAuth:!0,permission:"access.notification.settings",responses:{200:{description:"Dashboard data retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{status:{type:"string"},timestamp:{type:"string"},health:{type:"object"},metrics:{type:"object"},queue:{type:"object"},channels:{type:"object"}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse}};exports.default=async e=>{var t,a,i;const{ctx:s}=e;try{null===(t=null==s?void 0:s.step)||void 0===t||t.call(s,"Fetching notification service dashboard");const e=await notification_1.notificationService.healthCheck(),i=await notification_1.notificationService.getMetrics(),o=await RedisCache_1.redisCache.getCacheHitRate(),c=await notification_1.notificationQueue.getStats();null===(a=null==s?void 0:s.success)||void 0===a||a.call(s,"Dashboard data retrieved");return{status:e.status,timestamp:(new Date).toISOString(),health:{overall:e.status,redis:e.redis,channels:e.channels},metrics:{totalSent:i.sent,totalFailed:i.failed,successRate:i.successRate,cacheHitRate:parseFloat(o.toFixed(2))},queue:{waiting:c.waiting,active:c.active,completed:c.completed,failed:c.failed,delayed:c.delayed,health:c.failed>.1*c.completed?"degraded":"healthy"},channels:{available:e.channels,total:e.channels.length,breakdown:{IN_APP:i.channels.IN_APP||0,EMAIL:i.channels.EMAIL||0,SMS:i.channels.SMS||0,PUSH:i.channels.PUSH||0}},uptime:process.uptime()}}catch(e){null===(i=null==s?void 0:s.fail)||void 0===i||i.call(s,e.message);throw e}};