"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const notification_1=require("@b/services/notification"),RedisCache_1=require("@b/services/notification/cache/RedisCache"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Notification Service Health Check",description:"Get health status and metrics for the notification service",tags:["Admin","Notification","Monitoring"],requiresAuth:!0,permission:"access.notification.settings",responses:{200:{description:"Health status retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{status:{type:"string"},timestamp:{type:"string"},components:{type:"object"},uptime:{type:"number"}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse}};exports.default=async e=>{var t,i,s;const{ctx:a}=e;try{null===(t=null==a?void 0:a.step)||void 0===t||t.call(a,"Checking notification service health");const e=await notification_1.notificationService.healthCheck(),s=await RedisCache_1.redisCache.getCacheHitRate(),c=await notification_1.notificationQueue.getStats();null===(i=null==a?void 0:a.success)||void 0===i||i.call(a,"Health check completed");return{status:e.status,timestamp:(new Date).toISOString(),components:{redis:{connected:e.redis,cacheHitRate:`${s.toFixed(2)}%`},channels:{available:e.channels,total:e.channels.length},emailQueue:{waiting:c.waiting,active:c.active,completed:c.completed,failed:c.failed,delayed:c.delayed},metrics:e.metrics},uptime:process.uptime()}}catch(e){null===(s=null==a?void 0:a.fail)||void 0===s||s.call(a,e.message);throw e}};