"use strict";function generateTimeSeries(e,a){const t=[];if("24h"===e)for(let e=0;e<24;e++){const i=(0,date_fns_1.addHours)(a,e);t.push({date:i,total:0,sent:0,failed:0,read:0,inApp:0,email:0,sms:0,push:0})}else{const i="7d"===e?7:"30d"===e?30:90;for(let e=0;e<i;e++){const i=(0,date_fns_1.addDays)(a,e);t.push({date:i,total:0,sent:0,failed:0,read:0,inApp:0,email:0,sms:0,push:0})}}return t}function formatResponse(e,a){const t=a.reduce((e,a)=>e+a.total,0),i=a.reduce((e,a)=>e+a.sent,0),s=a.reduce((e,a)=>e+a.failed,0),n=a.reduce((e,a)=>e+a.read,0),l=Math.floor(a.length/2),r=a.slice(0,l),o=a.slice(l),d=r.reduce((e,a)=>e+a.total,0),u=o.reduce((e,a)=>e+a.total,0),c=d>0?(u-d)/d*100:u>0?100:0,f=r.reduce((e,a)=>e+a.failed,0),m=o.reduce((e,a)=>e+a.failed,0),p=f>0?(m-f)/f*100:m>0?100:0,h=t>0?(i/t*100).toFixed(1):"100.0",S=i>0?(n/i*100).toFixed(1):"0.0";return{timeframe:e,timestamp:(new Date).toISOString(),kpis:[{id:"totalNotifications",title:"Total Notifications",value:t,change:Math.round(10*c)/10,trend:a.map(e=>({date:e.date.toISOString(),value:e.total})),icon:"Bell"},{id:"successRate",title:"Success Rate",value:`${h}%`,change:0,trend:a.map(e=>({date:e.date.toISOString(),value:e.total>0?Math.round(e.sent/e.total*100):100})),icon:"CheckCircle2"},{id:"totalFailed",title:"Failed",value:s,change:Math.round(10*p)/10,trend:a.map(e=>({date:e.date.toISOString(),value:e.failed})),icon:"XCircle"},{id:"readRate",title:"Read Rate",value:`${S}%`,change:0,trend:a.map(e=>({date:e.date.toISOString(),value:e.sent>0?Math.round(e.read/e.sent*100):0})),icon:"Eye"}],charts:{notificationsOverTime:a.map(e=>({date:e.date.toISOString(),total:e.total,sent:e.sent,failed:e.failed})),channelBreakdown:a.map(e=>({date:e.date.toISOString(),"In-App":e.inApp,Email:e.email,SMS:e.sms,Push:e.push})),statusBreakdown:[{name:"Sent",value:i,color:"#22c55e"},{name:"Failed",value:s,color:"#ef4444"},{name:"Read",value:n,color:"#3b82f6"},{name:"Pending",value:Math.max(0,t-i-s),color:"#f59e0b"}],channelTotals:[{name:"In-App",value:a.reduce((e,a)=>e+a.inApp,0),color:"#3b82f6"},{name:"Email",value:a.reduce((e,a)=>e+a.email,0),color:"#22c55e"},{name:"SMS",value:a.reduce((e,a)=>e+a.sms,0),color:"#f59e0b"},{name:"Push",value:a.reduce((e,a)=>e+a.push,0),color:"#a855f7"}]}}}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),date_fns_1=require("date-fns"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Get Notification Analytics",description:"Retrieve time-series analytics data for notification charts",operationId:"getNotificationAnalytics",tags:["Admin","Notification","Analytics"],requiresAuth:!0,permission:"access.notification.settings",parameters:[{name:"timeframe",in:"query",description:"Time range for analytics",schema:{type:"string",enum:["24h","7d","30d","90d"],default:"7d"}}],responses:{200:{description:"Analytics data retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{timeframe:{type:"string"},timestamp:{type:"string"},kpis:{type:"array"},charts:{type:"object"}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse}};exports.default=async e=>{var a,t,i,s;const{query:n,ctx:l}=e;try{null===(a=null==l?void 0:l.step)||void 0===a||a.call(l,"Calculating notification analytics");const e=n.timeframe||"7d",s=new Date;let r,o,d;switch(e){case"24h":r=(0,date_fns_1.startOfHour)((0,date_fns_1.subHours)(s,23));o="hour";d="%Y-%m-%d %H:00:00";break;case"7d":default:r=(0,date_fns_1.startOfDay)((0,date_fns_1.subDays)(s,6));o="day";d="%Y-%m-%d 00:00:00";break;case"30d":r=(0,date_fns_1.startOfDay)((0,date_fns_1.subDays)(s,29));o="day";d="%Y-%m-%d 00:00:00";break;case"90d":r=(0,date_fns_1.startOfDay)((0,date_fns_1.subDays)(s,89));o="day";d="%Y-%m-%d 00:00:00"}const u=(0,date_fns_1.endOfDay)(s),c=generateTimeSeries(e,r,u);if(!db_1.models.notification){null===(t=null==l?void 0:l.warn)||void 0===t||t.call(l,"Notification model not available, returning sample data");return formatResponse(e,c.map(e=>({...e,total:Math.floor(100*Math.random())+20,sent:Math.floor(80*Math.random())+15,failed:Math.floor(10*Math.random()),read:Math.floor(60*Math.random())+10,inApp:Math.floor(40*Math.random())+10,email:Math.floor(30*Math.random())+5,sms:Math.floor(10*Math.random()),push:Math.floor(20*Math.random())+5})))}const f=await db_1.models.notification.findAll({where:{createdAt:{[sequelize_1.Op.between]:[r,u]}},attributes:[[sequelize_1.Sequelize.fn("DATE_FORMAT",sequelize_1.Sequelize.col("createdAt"),d),"dateGroup"],[sequelize_1.Sequelize.fn("COUNT","*"),"total"],[sequelize_1.Sequelize.fn("COUNT","*"),"sent"],[sequelize_1.Sequelize.literal("0"),"failed"],[sequelize_1.Sequelize.fn("SUM",sequelize_1.Sequelize.literal("CASE WHEN `read` = 1 THEN 1 ELSE 0 END")),"readCount"],[sequelize_1.Sequelize.fn("SUM",sequelize_1.Sequelize.literal("CASE WHEN JSON_CONTAINS(channels, '\"IN_APP\"') OR channels IS NULL THEN 1 ELSE 0 END")),"inApp"],[sequelize_1.Sequelize.fn("SUM",sequelize_1.Sequelize.literal("CASE WHEN JSON_CONTAINS(channels, '\"EMAIL\"') THEN 1 ELSE 0 END")),"email"],[sequelize_1.Sequelize.fn("SUM",sequelize_1.Sequelize.literal("CASE WHEN JSON_CONTAINS(channels, '\"SMS\"') THEN 1 ELSE 0 END")),"sms"],[sequelize_1.Sequelize.fn("SUM",sequelize_1.Sequelize.literal("CASE WHEN JSON_CONTAINS(channels, '\"PUSH\"') THEN 1 ELSE 0 END")),"push"]],group:["dateGroup"],raw:!0}),m=e=>"hour"===o?(0,date_fns_1.format)(e,"yyyy-MM-dd HH:00:00"):(0,date_fns_1.format)(e,"yyyy-MM-dd"),p=new Map(c.map(e=>[m(e.date),e]));f.forEach(e=>{const a="hour"===o?e.dateGroup:e.dateGroup.split(" ")[0];if(p.has(a)){const t=p.get(a);t.total=Number(e.total)||0;t.sent=Number(e.sent)||0;t.failed=Number(e.failed)||0;t.read=Number(e.readCount)||0;t.inApp=Number(e.inApp)||0;t.email=Number(e.email)||0;t.sms=Number(e.sms)||0;t.push=Number(e.push)||0}});const h=Array.from(p.values());null===(i=null==l?void 0:l.success)||void 0===i||i.call(l,"Notification analytics calculated");return formatResponse(e,h)}catch(e){null===(s=null==l?void 0:l.fail)||void 0===s||s.call(l,e.message);throw e}};