"use strict";async function getServiceMap(){const e={email:checkEmailService,stripe:checkStripeService,sms:checkSmsService,openexchangerates:checkOpenExchangeRatesService,googletranslate:checkGoogleTranslateService,ethereum:checkEthereumService,bsc:checkBscService,polygon:checkPolygonService,ftm:checkFtmService,optimism:checkOptimismService,arbitrum:checkArbitrumService,celo:checkCeloService},s=cache_1.CacheManager.getInstance();(await s.getExtensions()).has("ecosystem")&&(e.scylla=checkScyllaService);return e}async function checkEmailService(){if(void 0===process.env.NEXT_PUBLIC_APP_EMAIL||""===process.env.NEXT_PUBLIC_APP_EMAIL)return{service:"Email",status:"Down",message:"App Email address not found",timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")};try{const e=(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss");await emails_1.emailQueue.add({emailData:{TO:process.env.NEXT_PUBLIC_APP_EMAIL,FIRSTNAME:"test",TIME:e},emailType:"EmailTest"});const s=process.env.APP_EMAILER;return{service:"Email",status:"Up",message:`Email sent successfully using ${(0,lodash_1.capitalize)(s)}`,timestamp:e}}catch(e){return{service:"Email",status:"Down",message:e,timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}}async function checkStripeService(){const e=process.env.APP_STRIPE_SECRET_KEY;if(!e||""===e)return{service:"Stripe",status:"Down",message:"Stripe API key not found",timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")};try{const s=new stripe_1.default(e);await s.balance.retrieve();return{service:"Stripe",status:"Up",message:"Stripe API key valid",timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}catch(e){return{service:"Stripe",status:"Down",message:e.message,timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}}async function checkSmsService(){const e=process.env.APP_TWILIO_ACCOUNT_SID,s=process.env.APP_TWILIO_AUTH_TOKEN,t=process.env.APP_TWILIO_PHONE_NUMBER,a=process.env.APP_SUPPORT_PHONE_NUMBER||"+441234567890";if(!e||!s||!t||""===e||""===s||""===t)return{service:"SMS",status:"Down",message:"Twilio credentials not found or incomplete",timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")};try{const n=(0,twilio_1.default)(e,s);return{service:"SMS",status:"Up",message:`SMS sent successfully with Twilio, Message SID: ${(await n.messages.create({to:a,from:t,body:"Test SMS from our service"})).sid}`,timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}catch(e){let s;switch(e.code){case 20003:s="Permission Denied, check Twilio credentials";break;case 21614:s="Message body is empty";break;default:s=e.moreInfo}return{service:"SMS",status:"Down",message:s,timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}}async function checkOpenExchangeRatesService(){const e=process.env.APP_OPENEXCHANGERATES_APP_ID;if(!e||""===e)return{service:"OpenExchangeRates",status:"Down",message:"Open Exchange Rates App ID not found",timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")};try{const s=await fetch(`https://openexchangerates.org/api/latest.json?app_id=${e}`);if(!s.ok)throw new Error(`HTTP error ${s.status}: ${s.statusText}`);await s.json();return{service:"OpenExchangeRates",status:"Up",message:"Open Exchange Rates API key valid",timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}catch(e){return{service:"OpenExchangeRates",status:"Down",message:e.message,timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}}async function checkGoogleTranslateService(){const e=process.env.GOOGLE_TRANSLATE_API_KEY;if(!e||""===e)return{service:"GoogleTranslate",status:"Down",message:"Google Translate API key not found",timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")};try{const s=await fetch(`https://translation.googleapis.com/language/translate/v2?key=${e}&q=Hello&target=es`);if(!s.ok)throw new Error(`HTTP error ${s.status}: ${s.statusText}`);return{service:"GoogleTranslate",status:"Up",message:`Translation successful: ${(await s.json()).data.translations[0].translatedText}`,timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}catch(e){return{service:"GoogleTranslate",status:"Down",message:e.message,timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}}async function checkScyllaService(){const e=process.env.SCYLLA_USERNAME,s=process.env.SCYLLA_PASSWORD;if(!e||!s||""===e||""===s)return{service:"Scylla",status:"Down",message:"Scylla credentials not found or incomplete",timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")};const t=new cassandra_driver_1.Client({contactPoints:["localhost"],localDataCenter:"datacenter1",credentials:{username:e,password:s}});try{await t.connect();await t.execute("SELECT now() FROM system.local");return{service:"Scylla",status:"Up",message:"Scylla connection successful.",timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}catch(e){return{service:"Scylla",status:"Down",message:e.message,timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}finally{await t.shutdown()}}async function checkEthereumService(){const e=process.env.ETH_EXPLORER_API_KEY,s=process.env.ETH_NETWORK||"mainnet",t={mainnet:process.env.ETH_MAINNET_RPC,goerli:process.env.ETH_GOERLI_RPC,sepolia:process.env.ETH_SEPOLIA_RPC},a={mainnet:process.env.ETH_MAINNET_RPC_WSS,goerli:process.env.ETH_GOERLI_RPC_WSS,sepolia:process.env.ETH_SEPOLIA_RPC_WSS};return e&&t[s]&&""!==e&&""!==t[s]?checkEvmNetwork("Ethereum",t[s],a[s],s):{service:"Ethereum",status:"Down",message:"Ethereum Explorer API key or RPC endpoint not found",timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}async function checkBscService(){const e=process.env.BSC_EXPLORER_API_KEY,s=process.env.BSC_NETWORK||"mainnet",t={mainnet:process.env.BSC_MAINNET_RPC,testnet:process.env.BSC_TESTNET_RPC},a={mainnet:process.env.BSC_MAINNET_RPC_WSS,testnet:process.env.BSC_TESTNET_RPC_WSS};return e&&t[s]&&""!==e&&""!==t[s]?checkEvmNetwork("BSC",t[s],a[s],s):{service:"BSC",status:"Down",message:"BSC Explorer API key or RPC endpoint not found",timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}async function checkPolygonService(){const e=process.env.POLYGON_EXPLORER_API_KEY,s=process.env.POLYGON_NETWORK||"matic",t={matic:process.env.POLYGON_MATIC_RPC,"matic-mumbai":process.env.POLYGON_MATIC_MUMBAI_RPC},a={matic:process.env.POLYGON_MATIC_RPC_WSS,"matic-mumbai":process.env.POLYGON_MATIC_MUMBAI_RPC_WSS};return e&&t[s]&&""!==e&&""!==t[s]?checkEvmNetwork("Polygon",t[s],a[s],s):{service:"Polygon",status:"Down",message:"Polygon Explorer API key or RPC endpoint not found",timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}async function checkFtmService(){const e=process.env.FTM_EXPLORER_API_KEY,s=process.env.FTM_NETWORK||"mainnet",t={mainnet:process.env.FTM_MAINNET_RPC,testnet:process.env.FTM_TESTNET_RPC},a={mainnet:process.env.FTM_MAINNET_RPC_WSS,testnet:process.env.FTM_TESTNET_RPC_WSS};return e&&t[s]&&""!==e&&""!==t[s]?checkEvmNetwork("FTM",t[s],a[s],s):{service:"FTM",status:"Down",message:"FTM Explorer API key or RPC endpoint not found",timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}async function checkOptimismService(){const e=process.env.OPTIMISM_EXPLORER_API_KEY,s=process.env.OPTIMISM_NETWORK||"mainnet",t={mainnet:process.env.OPTIMISM_MAINNET_RPC,goerli:process.env.OPTIMISM_GOERLI_RPC},a={mainnet:process.env.OPTIMISM_MAINNET_RPC_WSS,goerli:process.env.OPTIMISM_GOERLI_RPC_WSS};return e&&t[s]&&""!==e&&""!==t[s]?checkEvmNetwork("Optimism",t[s],a[s],s):{service:"Optimism",status:"Down",message:"Optimism Explorer API key or RPC endpoint not found",timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}async function checkArbitrumService(){const e=process.env.ARBITRUM_EXPLORER_API_KEY,s=process.env.ARBITRUM_NETWORK||"mainnet",t={mainnet:process.env.ARBIRUM_MAINNET_RPC,goerli:process.env.ARBITRUM_GOERLI_RPC},a={mainnet:process.env.ARBIRUM_MAINNET_RPC_WSS,goerli:process.env.ARBITRUM_GOERLI_RPC_WSS};return e&&t[s]&&""!==e&&""!==t[s]?checkEvmNetwork("Arbitrum",t[s],a[s],s):{service:"Arbitrum",status:"Down",message:"Arbitrum Explorer API key or RPC endpoint not found",timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}async function checkCeloService(){const e=process.env.CELO_EXPLORER_API_KEY,s=process.env.CELO_NETWORK||"mainnet",t={mainnet:process.env.CELO_MAINNET_RPC,alfajores:process.env.CELO_ALFAJORES_RPC},a={mainnet:process.env.CELO_MAINNET_RPC_WSS,alfajores:process.env.CELO_ALFAJORES_RPC_WSS};return e&&t[s]&&""!==e&&""!==t[s]?checkEvmNetwork("Celo",t[s],a[s],s):{service:"Celo",status:"Down",message:"Celo Explorer API key or RPC endpoint not found",timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}async function checkEvmNetwork(e,s,t,a){if(!s||""===s)return{service:e,status:"Down",message:`${e} HTTP RPC endpoint not found`,timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")};try{const n={staticNetwork:!0},r=new ethers_1.ethers.JsonRpcProvider(s,a,n),c=await r.getBlockNumber();let o="";if(t&&""!==t)try{const e=new ethers_1.ethers.WebSocketProvider(t,a,n);o=` and WebSocket (latest block: ${await e.getBlockNumber()})`}catch(s){console_1.logger.error("HEALTH",`WSS connection error for ${e}: ${s.message}`,s);o=", but WebSocket connection failed"}return{service:e,status:"Up",message:`Connected to ${e} (${a}) via HTTP (latest block: ${c})${o}`,timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}catch(s){let t;switch(s.code){case"ENOTFOUND":t=`RPC endpoint for ${e} (${a}) not found.`;break;case"NETWORK_ERROR":t=`Network error: Failed to connect to ${e} (${a}).`;break;case"INVALID_ARGUMENT":t=`Problem with ${e} (${a}) configuration.`;break;case"SERVER_ERROR":t=`Server error: ${s.message}. RPC endpoint may be down.`;break;default:t=s.message}console_1.logger.error("HEALTH",`Failed to connect to ${e} RPC: ${s.message}`,s);return{service:e,status:"Down",message:t,timestamp:(0,date_fns_1.formatDate)(new Date,"yyyy-MM-dd HH:mm:ss")}}}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const emails_1=require("@b/utils/emails"),cassandra_driver_1=require("cassandra-driver"),date_fns_1=require("date-fns"),ethers_1=require("ethers"),lodash_1=require("lodash"),stripe_1=__importDefault(require("stripe")),twilio_1=__importDefault(require("twilio")),cache_1=require("@b/utils/cache"),console_1=require("@b/utils/console"),cachedResults={};exports.metadata={summary:"Gets system details",operationId:"getSystemDetails",tags:["Admin","System"],responses:{200:{description:"System details fetched successfully",content:{"application/json":{schema:{type:"object",properties:{}}}}},401:{description:"Unauthorized, admin permission required"},500:{description:"Internal system error"}},requiresAuth:!0,parameters:[{in:"query",name:"service",schema:{type:"string"},description:"Service name to check",required:!1}],permission:"access.admin",logModule:"ADMIN_SYSTEM",logTitle:"Get System Health"};const getOrCheckService=async(e,s)=>{if(cachedResults[e])return cachedResults[e];const t=await s();cachedResults[e]=t;return t};exports.default=async e=>{const{query:s,ctx:t}=e,{service:a}=s;null==t||t.step(`Checking ${a} service health`);const n=await getServiceMap(),r=n[a]?await getOrCheckService(a,n[a]):{};null==t||t.success("System health check completed");return{[a]:r}};