"use strict";async function getUserID(e,t){var a;null===(a=null==t?void 0:t.step)||void 0===a||a.call(t,`Getting user ID: ${e}`);const r=await db_1.models.user.findOne({where:{id:e}});if(!r)throw(0,error_1.createError)({statusCode:404,message:"Invalid user UUID"});return r.id}async function updateUserWalletBalance(e,t,a,r,n,s){const i=await wallet_1.walletCreationService.getWalletById(e);if(!i)throw(0,error_1.createError)({statusCode:404,message:"Wallet not found"});const c=n||`admin_${r.toLowerCase()}_${e}_${(0,uuid_1.v4)()}`;try{switch(r){case"DEPOSIT":{const r=t-a,n=await wallet_1.walletService.credit({idempotencyKey:c,userId:i.userId,walletId:e,walletType:i.type,currency:i.currency,amount:r,operationType:"DEPOSIT",fee:a,description:`Admin deposit of ${t} ${i.currency} (fee: ${a})`,metadata:{adminAction:!0,adminUserId:s,originalAmount:t,fee:a}});return{id:n.walletId,userId:i.userId,type:i.type,currency:i.currency,balance:n.newBalance,inOrder:n.newInOrder,status:i.status}}case"WITHDRAWAL":{const r=t+a,n=await wallet_1.walletService.debit({idempotencyKey:c,userId:i.userId,walletId:e,walletType:i.type,currency:i.currency,amount:r,operationType:"WITHDRAW",fee:a,description:`Admin withdrawal of ${t} ${i.currency} (fee: ${a})`,metadata:{adminAction:!0,adminUserId:s,originalAmount:t,fee:a}});return{id:n.walletId,userId:i.userId,type:i.type,currency:i.currency,balance:n.newBalance,inOrder:n.newInOrder,status:i.status}}case"REFUND_WITHDRAWAL":{const r=t+a,n=await wallet_1.walletService.credit({idempotencyKey:c,userId:i.userId,walletId:e,walletType:i.type,currency:i.currency,amount:r,operationType:"REFUND_WITHDRAWAL",description:`Admin withdrawal refund of ${t} ${i.currency} (fee refund: ${a})`,metadata:{adminAction:!0,adminUserId:s,originalAmount:t,fee:a}});return{id:n.walletId,userId:i.userId,type:i.type,currency:i.currency,balance:n.newBalance,inOrder:n.newInOrder,status:i.status}}default:throw(0,error_1.createError)({statusCode:400,message:`Unknown operation type: ${r}`})}}catch(e){if(e instanceof wallet_1.WalletError)throw(0,error_1.createError)({statusCode:400,message:e.message});throw e}}async function adjustWalletBalance(e,t,a,r){const n=await wallet_1.walletCreationService.getWalletById(e);if(!n)throw(0,error_1.createError)({statusCode:404,message:"Wallet not found"});const s=t-n.balance,i=`admin_adjust_${e}_${Date.now()}_${(0,uuid_1.v4)()}`;s>0?await wallet_1.walletService.credit({idempotencyKey:i,userId:n.userId,walletId:e,walletType:n.type,currency:n.currency,amount:s,operationType:"ADJUSTMENT",description:`Admin balance adjustment: ${a}`,metadata:{adminAction:!0,adminUserId:r,previousBalance:n.balance,newBalance:t,reason:a}}):s<0&&await wallet_1.walletService.debit({idempotencyKey:i,userId:n.userId,walletId:e,walletType:n.type,currency:n.currency,amount:Math.abs(s),operationType:"ADJUSTMENT",description:`Admin balance adjustment: ${a}`,metadata:{adminAction:!0,adminUserId:r,previousBalance:n.balance,newBalance:t,reason:a}});return await wallet_1.walletCreationService.getWalletById(e)}Object.defineProperty(exports,"__esModule",{value:!0});exports.walletUpdateSchema=exports.walletSchema=void 0;exports.getUserID=getUserID;exports.updateUserWalletBalance=updateUserWalletBalance;exports.adjustWalletBalance=adjustWalletBalance;const db_1=require("@b/db"),schema_1=require("@b/utils/schema"),wallet_1=require("@b/services/wallet"),uuid_1=require("uuid"),error_1=require("@b/utils/error"),id=(0,schema_1.baseStringSchema)("ID of the wallet"),type=(0,schema_1.baseStringSchema)("Type of the wallet"),currency=(0,schema_1.baseStringSchema)("Currency of the wallet"),balance=(0,schema_1.baseNumberSchema)("Current balance of the wallet"),inOrder=(0,schema_1.baseNumberSchema)("Amount currently held in orders"),address={type:"object",additionalProperties:!0,description:"Crypto address associated with the wallet"},status=(0,schema_1.baseBooleanSchema)("Status of the wallet (active or inactive)"),baseWalletProperties={id:id,type:type,currency:currency,balance:balance,inOrder:inOrder,status:status};exports.walletSchema={...baseWalletProperties,user:{type:"object",properties:{id:{type:"string",description:"User ID"},firstName:{type:"string",description:"First name of the user"},lastName:{type:"string",description:"Last name of the user"},avatar:{type:"string",description:"Avatar URL of the user"}}},transactions:{type:"array",description:"List of transactions associated with the wallet",items:{type:"object",properties:{id:{type:"string",description:"Transaction ID"},amount:{type:"number",description:"Amount of the transaction"},fee:{type:"number",description:"Transaction fee"},type:{type:"string",description:"Type of the transaction"},status:{type:"string",description:"Status of the transaction"},createdAt:{type:"string",format:"date-time",description:"Creation date of the transaction"},metadata:{type:"object",description:"Metadata of the transaction"}}}}};exports.walletUpdateSchema={type:"object",properties:{type:type,currency:currency,balance:balance,inOrder:inOrder,status:status},required:[],additionalProperties:!1};