"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),db_1=require("@b/db");exports.metadata={summary:"Retrieves a list of users",description:"This endpoint retrieves active users for selection in the UI. Each option includes the user's ID and full name (or email if a full name is not available).",operationId:"getUserOptions",tags:["User"],requiresAuth:!0,responses:{200:{description:"Users retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string"},name:{type:"string"}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("User"),500:query_1.serverErrorResponse},logModule:"ADMIN_CRM",logTitle:"Get User Options",demoMask:["name"]};exports.default=async e=>{const{user:r,ctx:s}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)(401,"Unauthorized");try{null==s||s.step("Fetching active users");const e=(await db_1.models.user.findAll({where:{status:"ACTIVE"}})).map(e=>{const r=e.firstName&&e.lastName?`${e.firstName} ${e.lastName} - ${e.id}`:e.email;return{id:e.id,name:r}});null==s||s.success("User options retrieved successfully");return e}catch(e){throw(0,error_1.createError)(500,"An error occurred while fetching users")}};