"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const utils_1=require("./utils"),db_1=require("@b/db"),query_1=require("@b/utils/query"),error_1=require("@b/utils/error");exports.metadata={summary:"Stores a new role",operationId:"storeRole",tags:["Admin","CRM","Role"],logModule:"ADMIN_CRM",logTitle:"Create role",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:utils_1.baseRoleSchema,required:["name","permissions"]}}}},responses:(0,query_1.storeRecordResponses)(utils_1.roleStoreSchema,"Role"),requiresAuth:!0,permission:"create.role"};exports.default=async e=>{const{body:r,user:s,ctx:o}=e,{name:t,permissions:i}=r;null==o||o.step("Validating user authorization");if(!(null==s?void 0:s.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const l=await db_1.models.user.findByPk(s.id,{include:[{model:db_1.models.role,as:"role"}]});if(!l||!l.role||"Super Admin"!==l.role.name)throw(0,error_1.createError)({statusCode:403,message:"Forbidden - Only Super Admins can create new roles"});null==o||o.step("Creating new role");const a=await db_1.models.role.create({name:t});null==o||o.step("Assigning permissions to role");const n=i.map(e=>Number(e));await a.setPermissions(n);const u=await db_1.models.role.findByPk(a.id,{include:[{model:db_1.models.permission,as:"permissions"}]});null==o||o.step("Updating roles cache");await(0,utils_1.cacheRoles)();null==o||o.success();return{message:"Role created successfully",role:u}};