"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),utils_1=require("./utils"),query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console");exports.metadata={summary:"Bulk deletes roles",operationId:"deleteBulkRoles",tags:["Admin","CRM","Role"],logModule:"ADMIN_CRM",logTitle:"Bulk delete roles",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"number"},description:"Array of role IDs to delete"}},required:["ids"]}}}},permission:"delete.role",responses:(0,query_1.commonBulkDeleteResponses)("Roles"),requiresAuth:!0};exports.default=async e=>{const{body:r,user:o,ctx:s}=e,{ids:t}=r;null==s||s.step("Validating user authorization");if(!(null==o?void 0:o.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const l=await db_1.models.user.findByPk(o.id,{include:[{model:db_1.models.role,as:"role"}]});if(!l||"Super Admin"!==l.role.name)throw(0,error_1.createError)({statusCode:403,message:"Forbidden - Only Super Admins can delete roles"});null==s||s.step("Validating role deletion permissions");const i=await db_1.models.role.findOne({where:{name:"Super Admin"}});if(t.includes(i.id))throw(0,error_1.createError)({statusCode:403,message:"Forbidden - Cannot delete Super Admin role"});try{null==s||s.step(`Deleting ${t.length} roles`);await db_1.sequelize.transaction(async e=>{await db_1.models.rolePermission.destroy({where:{roleId:t},transaction:e});await db_1.models.role.destroy({where:{id:t},transaction:e})});null==s||s.step("Rebuilding roles cache");await(0,utils_1.cacheRoles)();null==s||s.success();return{message:"Roles removed successfully"}}catch(e){console_1.logger.error("ROLE","Failed to remove roles",e);throw(0,error_1.createError)({statusCode:500,message:"Failed to remove roles"})}};