"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error");exports.metadata={summary:"Get KYC Analytics Data",description:"Fetches analytics data for KYC including total users, verified users, pending verifications, rejected verifications, and completion rates for each level.",operationId:"getKycAnalyticsData",tags:["KYC","Analytics"],logModule:"ADMIN_CRM",logTitle:"Get KYC level analytics",responses:{200:{description:"KYC analytics data retrieved successfully.",content:{"application/json":{schema:{type:"object",properties:{totalUsers:{type:"number"},verifiedUsers:{type:"number"},pendingVerifications:{type:"number"},rejectedVerifications:{type:"number"},completionRates:{type:"array",items:{type:"object",properties:{level:{type:"number"},name:{type:"string"},rate:{type:"number"},users:{type:"number"}}}}}}}}},500:{description:"Internal Server Error."}},permission:"view.kyc.level",requiresAuth:!0};exports.default=async e=>{const{ctx:t}=e;try{null==t||t.step("Fetching analytics data");const e=await db_1.models.kycApplication.findAll(),r=await db_1.models.kycLevel.findAll(),s=(await db_1.models.user.findAll()).length,a=e.filter(e=>"APPROVED"===e.status).length,i=e.filter(e=>"PENDING"===e.status).length,l=e.filter(e=>"REJECTED"===e.status).length,n=r.map(t=>{const r=e.filter(e=>e.levelId===t.id),s=r.filter(e=>"APPROVED"===e.status),a=r.length>0?Math.round(s.length/r.length*100):0;return{level:t.level,name:t.name,rate:a,users:s.length}}).sort((e,t)=>e.level-t.level);null==t||t.success("KYC level analytics generated successfully");return{totalUsers:s,verifiedUsers:a,pendingVerifications:i,rejectedVerifications:l,completionRates:n}}catch(e){console.error("Error in getKycAnalyticsData:",e);throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error: "+e.message})}};