"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),constants_1=require("@b/utils/constants"),utils_1=require("./utils");exports.metadata={summary:"Lists all KYC applications with pagination and optional filtering",operationId:"listKycApplications",tags:["Admin","CRM","KYC"],parameters:constants_1.crudParameters,logModule:"ADMIN_CRM",logTitle:"List KYC applications",responses:{200:{description:"Paginated list of KYC applications with detailed user and template information",content:{"application/json":{schema:{type:"object",properties:{data:{type:"array",items:{type:"object",properties:utils_1.kycApplicationSchema}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("KYC Applications"),500:query_1.serverErrorResponse},requiresAuth:!0,permission:"view.kyc.application",demoMask:["items.user.email"]};exports.default=async e=>{const{query:t,ctx:i}=e;null==i||i.step("Fetching KYC applications");const s=await(0,query_1.getFiltered)({model:db_1.models.kycApplication,query:t,sortField:t.sortField||"createdAt",includeModels:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar"]},{model:db_1.models.kycLevel,as:"level",attributes:["id","name","description"],paranoid:!1,includeModels:[{model:db_1.models.kycVerificationService,as:"verificationService",attributes:["id","name"]}]},{model:db_1.models.kycVerificationResult,as:"verificationResult",attributes:["id","status","createdAt"]}]});null==i||i.success("KYC applications retrieved successfully");return s};