"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error");exports.metadata={summary:"Get KYC Applications Analytics Data",description:"Fetches analytics data for KYC applications including total applications, pending, approved, rejected, additional info required, completion rate, and average processing time.",operationId:"getKycApplicationsAnalyticsData",tags:["KYC","Analytics"],logModule:"ADMIN_CRM",logTitle:"Get KYC applications analytics",responses:{200:{description:"KYC applications analytics data retrieved successfully.",content:{"application/json":{schema:{type:"object",properties:{total:{type:"number"},pending:{type:"number"},approved:{type:"number"},rejected:{type:"number"},infoRequired:{type:"number"},completionRate:{type:"number"},averageProcessingTime:{type:"number"}}}}}},500:{description:"Internal Server Error."}},requiresAuth:!0,permission:"view.kyc.application"};exports.default=async e=>{const{ctx:t}=e;try{null==t||t.step("Fetching all KYC applications");const e=await db_1.models.kycApplication.findAll(),r=e.length,a=e.filter(e=>"PENDING"===e.status).length,i=e.filter(e=>"APPROVED"===e.status).length,n=e.filter(e=>"REJECTED"===e.status).length,s=e.filter(e=>"ADDITIONAL_INFO_REQUIRED"===e.status).length,o=r>0?(i+n)/r*100:0,l=e.filter(e=>e.reviewedAt),c=l.reduce((e,t)=>{const r=new Date(t.createdAt).getTime();return e+(new Date(t.reviewedAt).getTime()-r)/36e5},0),p=l.length>0?c/l.length:0;null==t||t.success("KYC applications analytics generated successfully");return{total:r,pending:a,approved:i,rejected:n,infoRequired:s,completionRate:o,averageProcessingTime:p}}catch(e){console.error("Error in getKycApplicationsAnalyticsData:",e);throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error: "+e.message})}};