"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),db_1=require("@b/db");exports.metadata={summary:"Retrieves a list of authors",description:"This endpoint retrieves a list of authors with their associated user names. Optionally, you can filter by status.",operationId:"getAuthors",tags:["Author"],requiresAuth:!0,parameters:[{index:0,name:"status",in:"query",required:!1,schema:{type:"string",enum:["PENDING","APPROVED","REJECTED"]}}],responses:{200:{description:"Authors retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string"},name:{type:"string"}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Author"),500:query_1.serverErrorResponse},logModule:"ADMIN_BLOG",logTitle:"Get author options"};exports.default=async e=>{const{user:t,ctx:r}=e;null==r||r.step("Validating user authorization");if(!(null==t?void 0:t.id))throw(0,error_1.createError)(401,"Unauthorized");null==r||r.step("Fetching approved authors");const s=await db_1.models.author.findAll({where:{status:"APPROVED"},include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email"]}]});null==r||r.step("Formatting author options");const o=s.map(e=>({id:e.id,name:`${e.user.firstName} ${e.user.lastName}`}));null==r||r.success(`${o.length} author options retrieved`);return o};