"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get User's Staking Positions",description:"Retrieves all staking positions for the authenticated user with pagination support.",operationId:"getUserStakingPositions",tags:["Staking","Positions"],requiresAuth:!0,parameters:[{index:0,name:"status",in:"query",required:!1,schema:{type:"string",enum:["ACTIVE","LOCKED","PENDING_WITHDRAWAL","COMPLETED"]},description:"Filter by position status"},{index:1,name:"poolId",in:"query",required:!1,schema:{type:"string"},description:"Filter by pool ID"},{index:2,name:"page",in:"query",required:!1,schema:{type:"integer",minimum:1,default:1},description:"Page number for pagination"},{index:3,name:"limit",in:"query",required:!1,schema:{type:"integer",minimum:1,maximum:100,default:20},description:"Number of items per page"}],responses:{200:{description:"Positions retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{data:{type:"array",items:{type:"object"}},pagination:{type:"object",properties:{page:{type:"integer"},limit:{type:"integer"},total:{type:"integer"},totalPages:{type:"integer"}}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{user:t,query:i,ctx:s}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==s||s.step("Fetching user staking positions");const a=parseInt(i.page)||1,n=Math.min(parseInt(i.limit)||20,100),r=(a-1)*n,o={userId:t.id};if(i.status)if("LOCKED"===i.status){o.status="ACTIVE";o.endDate={[sequelize_1.Op.gt]:new Date}}else o.status=i.status;i.poolId&&(o.poolId=i.poolId);const d=await db_1.models.stakingPosition.count({where:o}),u=await db_1.models.stakingPosition.findAll({where:o,include:[{model:db_1.models.stakingPool,as:"pool"}],order:[["createdAt","DESC"]],limit:n,offset:r}),p=await Promise.all(u.map(async e=>{const t=await db_1.models.stakingEarningRecord.sum("amount",{where:{positionId:e.id}}),i=await db_1.models.stakingEarningRecord.sum("amount",{where:{positionId:e.id,isClaimed:!1}});let s=null;if("ACTIVE"===e.status&&e.endDate&&new Date(e.endDate)>new Date){const t=new Date,i=new Date(e.endDate);s=Math.floor((i.getTime()-t.getTime())/864e5)}return{...e.toJSON(),earnings:{total:t||0,unclaimed:i||0},timeRemaining:s}}));null==s||s.success(`Retrieved ${p.length} staking positions`);return{data:p,pagination:{page:a,limit:n,total:d,totalPages:Math.ceil(d/n)}}};