"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Available Staking Pools",description:"Retrieves all active staking pools available for users to stake in.",operationId:"getStakingPools",tags:["Staking","Pools"],requiresAuth:!0,parameters:[{index:0,name:"token",in:"query",required:!1,schema:{type:"string"},description:"Filter pools by token name"},{index:1,name:"minApr",in:"query",required:!1,schema:{type:"number"},description:"Minimum APR filter"},{index:2,name:"maxApr",in:"query",required:!1,schema:{type:"number"},description:"Maximum APR filter"},{index:3,name:"minLockPeriod",in:"query",required:!1,schema:{type:"number"},description:"Minimum staking duration in days"}],responses:{200:{description:"Staking pools retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{pools:{type:"array",items:{type:"object"}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{user:t,query:r,ctx:o}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==o||o.step("Building query filters");const s={status:"ACTIVE"};r.token&&(s.token=r.token);r.minApr&&(s.apr={...s.apr||{},[sequelize_1.Op.gte]:Number.parseFloat(r.minApr)});r.maxApr&&(s.apr={...s.apr||{},[sequelize_1.Op.lte]:Number.parseFloat(r.maxApr)});r.minLockPeriod&&(s.lockPeriod={[sequelize_1.Op.gte]:Number.parseInt(r.minLockPeriod)});const i=await db_1.models.stakingPool.findAll({where:s,order:[["order","ASC"]]}),a=i.map(e=>e.id);if(0===a.length)return[];const n=(await db_1.models.stakingPosition.findAll({attributes:["poolId",[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalStaked"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.fn)("DISTINCT",(0,sequelize_1.col)("userId"))),"totalStakers"]],where:{poolId:a,status:{[sequelize_1.Op.in]:["ACTIVE","COMPLETED"]}},group:["poolId"],raw:!0})).reduce((e,t)=>{e[t.poolId]={totalStaked:parseFloat(t.totalStaked)||0,totalStakers:parseInt(t.totalStakers)||0};return e},{}),l=(await db_1.models.stakingPosition.findAll({attributes:["poolId",[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"userTotalStaked"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"userPositionsCount"]],where:{poolId:a,userId:t.id,status:{[sequelize_1.Op.in]:["ACTIVE","COMPLETED"]}},group:["poolId"],raw:!0})).reduce((e,t)=>{e[t.poolId]={userTotalStaked:parseFloat(t.userTotalStaked)||0,userPositionsCount:parseInt(t.userPositionsCount)||0};return e},{}),u=i.map(e=>{const t=n[e.id]||{totalStaked:0,totalStakers:0},r=l[e.id]||{userTotalStaked:0,userPositionsCount:0};return{...e.toJSON(),totalStaked:t.totalStaked,analytics:{totalStakers:t.totalStakers,userTotalStaked:r.userTotalStaked,userPositionsCount:r.userPositionsCount}}});null==o||o.success(`Retrieved ${u.length} staking pools`);return u};