"use strict";function getTimeAgo(e){const t=Math.floor(((new Date).getTime()-e.getTime())/1e3);if(t<60)return`${t}s ago`;const a=Math.floor(t/60);if(a<60)return`${a}m ago`;const o=Math.floor(a/60);if(o<24)return`${o}h ago`;return`${Math.floor(o/24)}d ago`}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Staking landing page data",description:"Retrieves comprehensive data for the Staking landing page including stats, featured pools, token diversity, and activity.",operationId:"getStakingLanding",tags:["Staking","Landing"],requiresAuth:!1,responses:{200:{description:"Staking landing page data retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{stats:{type:"object"},featuredPools:{type:"array"},highestAprPools:{type:"array"},flexiblePools:{type:"array"},upcomingPools:{type:"array"},tokenStats:{type:"array"},recentActivity:{type:"array"},performance:{type:"object"},earningFrequencies:{type:"array"},calculatorPreview:{type:"object"}}}}}}}};exports.default=async()=>{const e=new Date,t=new Date(e.getTime()-2592e6),a=new Date(e.getTime()-6048e5),o=new Date(e.getFullYear(),e.getMonth(),1),l=new Date(e.getFullYear(),e.getMonth()-1,1),i=new Date(e.getFullYear(),e.getMonth(),0),[r,s,n,d,u,p,m,c,g,E,A]=await Promise.all([db_1.models.stakingPool.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"totalPools"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN status = 'ACTIVE' THEN 1 ELSE 0 END")),"activePools"],[(0,sequelize_1.fn)("AVG",(0,sequelize_1.literal)("CASE WHEN status = 'ACTIVE' THEN apr ELSE NULL END")),"avgApr"],[(0,sequelize_1.fn)("MAX",(0,sequelize_1.literal)("CASE WHEN status = 'ACTIVE' THEN apr ELSE NULL END")),"highestApr"],[(0,sequelize_1.fn)("MIN",(0,sequelize_1.literal)("CASE WHEN status = 'ACTIVE' THEN apr ELSE NULL END")),"lowestApr"],[(0,sequelize_1.fn)("AVG",(0,sequelize_1.literal)("CASE WHEN status = 'ACTIVE' THEN lockPeriod ELSE NULL END")),"avgLockPeriod"]],raw:!0}),db_1.models.stakingPosition.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalStaked"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("DISTINCT userId")),"activeUsers"],[(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("amount")),"avgStakeAmount"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN status = 'COMPLETED' THEN 1 ELSE 0 END")),"completedPositions"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"totalPositions"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt >= '${o.toISOString()}' THEN amount ELSE 0 END`)),"currentStaked"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt BETWEEN '${l.toISOString()}' AND '${i.toISOString()}' THEN amount ELSE 0 END`)),"previousStaked"]],where:{status:{[sequelize_1.Op.in]:["ACTIVE","COMPLETED"]}},raw:!0}),db_1.models.stakingEarningRecord.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalRewards"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN isClaimed = true THEN amount ELSE 0 END")),"totalClaimed"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt >= '${a.toISOString()}' THEN amount ELSE 0 END`)),"last7DaysRewards"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt >= '${t.toISOString()}' THEN amount ELSE 0 END`)),"last30DaysRewards"]],raw:!0}),db_1.models.stakingPool.findAll({where:{status:"ACTIVE",isPromoted:!0},order:[["order","ASC"]],limit:6}),db_1.models.stakingPool.findAll({where:{status:"ACTIVE"},order:[["apr","DESC"]],limit:4}),db_1.models.stakingPool.findAll({where:{status:"ACTIVE",lockPeriod:{[sequelize_1.Op.lte]:30}},order:[["lockPeriod","ASC"]],limit:4}),db_1.models.stakingPool.findAll({where:{status:"COMING_SOON"},order:[["order","ASC"]],limit:3}),db_1.models.stakingPool.findAll({attributes:["token","symbol","icon",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"poolCount"],[(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("apr")),"avgApr"],[(0,sequelize_1.fn)("MAX",(0,sequelize_1.col)("apr")),"highestApr"]],where:{status:"ACTIVE"},group:["token","symbol","icon"],order:[[(0,sequelize_1.literal)("poolCount"),"DESC"]],limit:6,raw:!0}),db_1.models.stakingPosition.findAll({attributes:["amount","createdAt","poolId"],where:{createdAt:{[sequelize_1.Op.gte]:t}},order:[["createdAt","DESC"]],limit:5,include:[{model:db_1.models.stakingPool,as:"pool",attributes:["name","symbol"]}]}),db_1.models.stakingEarningRecord.findAll({attributes:["amount","claimedAt","positionId"],where:{isClaimed:!0,claimedAt:{[sequelize_1.Op.gte]:t}},order:[["claimedAt","DESC"]],limit:5,include:[{model:db_1.models.stakingPosition,as:"position",attributes:["poolId"],include:[{model:db_1.models.stakingPool,as:"pool",attributes:["name","symbol"]}]}]}),db_1.models.stakingPool.findAll({attributes:["earningFrequency",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"poolCount"],[(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("apr")),"avgApr"]],where:{status:"ACTIVE"},group:["earningFrequency"],raw:!0})]),S=parseFloat(null==s?void 0:s.totalStaked)||0,y=parseInt(null==s?void 0:s.activeUsers)||0,_=parseInt(null==r?void 0:r.totalPools)||0,q=parseInt(null==r?void 0:r.activePools)||0,v=parseFloat(null==r?void 0:r.avgApr)||0,k=parseFloat(null==r?void 0:r.highestApr)||0,w=parseFloat(null==r?void 0:r.lowestApr)||0,b=parseFloat(null==r?void 0:r.avgLockPeriod)||0,C=parseFloat(null==s?void 0:s.avgStakeAmount)||0,f=parseInt(null==s?void 0:s.completedPositions)||0,z=parseInt(null==s?void 0:s.totalPositions)||0,P=z>0?Math.round(f/z*100):0,h=parseFloat(null==n?void 0:n.totalRewards)||0,N=parseFloat(null==n?void 0:n.totalClaimed)||0,T=h-N,I=parseFloat(null==n?void 0:n.last7DaysRewards)||0,D=parseFloat(null==n?void 0:n.last30DaysRewards)||0,M=D/30,F=parseFloat(null==s?void 0:s.currentStaked)||0,O=parseFloat(null==s?void 0:s.previousStaked)||0,L=O>0?Math.round((F-O)/O*100):0,R=d.map(e=>e.id),U=R.length>0?await db_1.models.stakingPosition.findAll({attributes:["poolId",[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalStaked"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("DISTINCT userId")),"totalStakers"]],where:{poolId:{[sequelize_1.Op.in]:R},status:{[sequelize_1.Op.in]:["ACTIVE","COMPLETED"]}},group:["poolId"],raw:!0}):[],H={};U.forEach(e=>{H[e.poolId]=e});const V=d.map(e=>{const t=H[e.id]||{},a=parseFloat(t.totalStaked)||0,o=a+e.availableToStake,l=o>0?Math.round(a/o*100):0;return{id:e.id,name:e.name,symbol:e.symbol,icon:e.icon,description:e.description,apr:e.apr,lockPeriod:e.lockPeriod,minStake:e.minStake,maxStake:e.maxStake,availableToStake:e.availableToStake,totalStaked:a,capacity:l,earningFrequency:e.earningFrequency,autoCompound:e.autoCompound,totalStakers:parseInt(t.totalStakers)||0,walletType:e.walletType}}),W=u.map(e=>({id:e.id,name:e.name,symbol:e.symbol,icon:e.icon,apr:e.apr,lockPeriod:e.lockPeriod,earningFrequency:e.earningFrequency})),G=p.map(e=>({id:e.id,name:e.name,symbol:e.symbol,icon:e.icon,apr:e.apr,lockPeriod:e.lockPeriod,earlyWithdrawalFee:e.earlyWithdrawalFee})),x=m.map(e=>({id:e.id,name:e.name,symbol:e.symbol,icon:e.icon,description:e.description,apr:e.apr,lockPeriod:e.lockPeriod})),$=c.map(e=>({token:e.token,symbol:e.symbol,icon:e.icon,poolCount:parseInt(e.poolCount)||0,avgApr:parseFloat(e.avgApr)||0,highestApr:parseFloat(e.highestApr)||0})),j=[...g.map(e=>{var t,a;return{type:"STAKE",amount:e.amount,symbol:(null===(t=e.pool)||void 0===t?void 0:t.symbol)||"TOKEN",poolName:(null===(a=e.pool)||void 0===a?void 0:a.name)||"Pool",timeAgo:getTimeAgo(new Date(e.createdAt))}}),...E.map(e=>{var t,a,o,l;return{type:"CLAIM",amount:e.amount,symbol:(null===(a=null===(t=e.position)||void 0===t?void 0:t.pool)||void 0===a?void 0:a.symbol)||"TOKEN",poolName:(null===(l=null===(o=e.position)||void 0===o?void 0:o.pool)||void 0===l?void 0:l.name)||"Pool",timeAgo:getTimeAgo(new Date(e.claimedAt))}})].sort((e,t)=>e.timeAgo.localeCompare(t.timeAgo)).slice(0,8),K=A.map(e=>({frequency:e.earningFrequency,poolCount:parseInt(e.poolCount)||0,avgApr:parseFloat(e.avgApr)||0})),Y=u[0],X=Y?{samplePool:{name:Y.name,symbol:Y.symbol,apr:Y.apr},examples:[{amount:100,dailyReward:100*Y.apr/100/365,monthlyReward:100*Y.apr/100/12,yearlyReward:100*Y.apr/100},{amount:1e3,dailyReward:1e3*Y.apr/100/365,monthlyReward:1e3*Y.apr/100/12,yearlyReward:1e3*Y.apr/100},{amount:1e4,dailyReward:1e4*Y.apr/100/365,monthlyReward:1e4*Y.apr/100/12,yearlyReward:1e4*Y.apr/100}]}:null;return{stats:{totalStaked:S,activeUsers:y,totalPools:_,activePools:q,avgApr:Math.round(100*v)/100,highestApr:k,lowestApr:w,totalRewards:h,totalClaimed:N,unclaimedRewards:T,stakedGrowth:L,usersGrowth:0,rewardsGrowth:0,avgLockPeriod:Math.round(b),avgStakeAmount:Math.round(100*C)/100,completionRate:P},featuredPools:V,highestAprPools:W,flexiblePools:G,upcomingPools:x,tokenStats:$,recentActivity:j,performance:{last7DaysRewards:I,last30DaysRewards:D,avgDailyRewards:Math.round(100*M)/100,peakApr:k,peakAprDate:null},earningFrequencies:K,calculatorPreview:X}};