"use strict";function mapEventToActivityType(e){const t=(e||"").toUpperCase().replace(/\s+/g,"_");return t.includes("INITIATED")||t.includes("CREATED")||t.includes("STARTED")?"TRADE_CREATED":t.includes("PAYMENT")&&t.includes("SENT")?"PAYMENT_CONFIRMED":t.includes("COMPLETED")||t.includes("RELEASED")?"TRADE_COMPLETED":t.includes("DISPUTED")?"TRADE_DISPUTED":t.includes("CANCELLED")?"TRADE_CANCELLED":"TRADE_UPDATE"}function formatActivityMessage(e,t,r){const i=(e||"").toUpperCase().replace(/\s+/g,"_"),d=`${r||0} ${t||"N/A"}`;if(i.includes("INITIATED")||i.includes("CREATED")||i.includes("STARTED"))return`Trade initiated for ${d}`;if(i.includes("PAYMENT")&&i.includes("SENT"))return`Payment confirmed for ${d}`;if(i.includes("COMPLETED"))return`Trade completed for ${d}`;if(i.includes("RELEASED"))return`Funds released for ${d}`;if(i.includes("DISPUTED"))return`Trade disputed for ${d}`;if(i.includes("CANCELLED"))return`Trade cancelled for ${d}`;return`${e.replace(/_/g," ").replace(/\b\w/g,e=>e.toUpperCase())} - ${d}`}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),sequelize_1=require("sequelize"),error_1=require("@b/utils/error");exports.metadata={summary:"Get Trade Dashboard Data",description:"Retrieves aggregated trade data for the authenticated user.",operationId:"getP2PTradeDashboardData",tags:["P2P","Trade"],logModule:"P2P",logTitle:"Get trade dashboard",responses:{200:{description:"Trade dashboard data retrieved successfully."},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:t,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==r||r.step("Fetching trade statistics and activity");try{const[i,d,a,s,o,n]=await Promise.all([db_1.models.p2pTrade.count({where:{[sequelize_1.Op.or]:[{buyerId:t.id},{sellerId:t.id}]}}),db_1.models.p2pTrade.count({where:{status:"COMPLETED",[sequelize_1.Op.or]:[{buyerId:t.id},{sellerId:t.id}]}}),db_1.models.p2pTrade.findAll({where:{status:"DISPUTED",[sequelize_1.Op.or]:[{buyerId:t.id},{sellerId:t.id}]},include:[{association:"paymentMethodDetails",attributes:["id","name","icon"],required:!1},{association:"offer",attributes:["id","priceCurrency"],required:!1}],limit:7,order:[["updatedAt","DESC"]]}),db_1.models.p2pTrade.findAll({where:{status:{[sequelize_1.Op.in]:["IN_PROGRESS","PENDING","PAYMENT_SENT","ESCROW_RELEASED"]},[sequelize_1.Op.or]:[{buyerId:t.id},{sellerId:t.id}]},include:[{association:"paymentMethodDetails",attributes:["id","name","icon"],required:!1},{association:"offer",attributes:["id","priceCurrency"],required:!1}],order:[["updatedAt","DESC"]]}),db_1.models.p2pTrade.findAll({where:{status:"PENDING",[sequelize_1.Op.or]:[{buyerId:t.id},{sellerId:t.id}]},include:[{association:"paymentMethodDetails",attributes:["id","name","icon"],required:!1},{association:"offer",attributes:["id","priceCurrency"],required:!1}],order:[["createdAt","DESC"]]}),db_1.models.p2pTrade.findAll({where:{[sequelize_1.Op.or]:[{buyerId:t.id},{sellerId:t.id}]},include:[{association:"offer",attributes:["id","priceCurrency"],required:!1}],order:[["updatedAt","DESC"]]})]),u=[],c=n.slice(0,10);for(const f of c){const y=f.toJSON?f.toJSON():f;let b=y.timeline||[];if("string"==typeof b)try{b=JSON.parse(b)}catch(h){b=[]}Array.isArray(b)||(b=[]);for(const C of b){if("MESSAGE"===C.event)continue;const I=C.timestamp||C.createdAt||C.time;I&&u.push({id:`${y.id}-${I}`,tradeId:y.id,type:mapEventToActivityType(C.event),message:formatActivityMessage(C.event,y.currency,y.amount),time:I,createdAt:new Date(I)})}}u.sort((e,t)=>new Date(t.createdAt).getTime()-new Date(e.createdAt).getTime());const l=u.slice(0,5),p=n.reduce((e,t)=>e+(t.total||t.fiatAmount||0),0),E=(()=>{const e=n.filter(e=>"COMPLETED"===e.status&&e.completedAt&&e.createdAt);if(!e.length)return null;const t=e.reduce((e,t)=>e+(new Date(t.completedAt).getTime()-new Date(t.createdAt).getTime()),0)/e.length,r=Math.floor(t/36e5),i=Math.floor(t%36e5/6e4);return r?`${r}h ${i}m`:`${i}m`})(),m=i?Math.round(d/i*100):0,T=e=>e.buyerId===t.id?e.sellerName||`User #${e.sellerId}`:e.buyerName||`User #${e.buyerId}`;function D(e){var r,i;const d=e.toJSON?e.toJSON():e;let a=d.status;if("PENDING"===a&&d.expiresAt){const e=new Date;new Date(d.expiresAt)<e&&(a="EXPIRED")}return{id:d.id,type:d.buyerId===t.id?"BUY":"SELL",coin:d.currency||d.coin||d.crypto||"N/A",amount:d.amount,fiatAmount:d.total||d.fiatAmount||0,price:d.price,counterparty:T(d),status:a,date:d.updatedAt||d.createdAt,paymentMethod:(null===(r=d.paymentMethodDetails)||void 0===r?void 0:r.name)||d.paymentMethod||null,priceCurrency:(null===(i=d.offer)||void 0===i?void 0:i.priceCurrency)||"USD"}}const A=[...new Set(n.map(e=>e.currency).filter(e=>e))].sort();null==r||r.success(`Trade dashboard retrieved (${i} total trades, ${d} completed)`);return{tradeStats:{activeCount:s.length,completedCount:d,totalVolume:p,avgCompletionTime:E,successRate:m},recentActivity:l,activeTrades:s.map(D),pendingTrades:o.map(D),completedTrades:n.filter(e=>"COMPLETED"===e.status).sort((e,t)=>new Date(t.updatedAt).getTime()-new Date(e.updatedAt).getTime()).slice(0,7).map(D),disputedTrades:a.map(D),availableCurrencies:A}}catch(_){null==r||r.fail(_.message||"Failed to retrieve trade dashboard");throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error: "+_.message})}};