"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),sequelize_1=require("sequelize"),error_1=require("@b/utils/error");exports.metadata={summary:"Get Popular Offers",description:"Retrieves popular offers ordered by a calculated popularity score based on the number of completed trades (via offerId) and average review ratings from those trades.",operationId:"getPopularOffers",tags:["P2P","Offer"],logModule:"P2P",logTitle:"Get popular offers",parameters:[{name:"limit",in:"query",description:"Maximum number of offers to return",required:!0,schema:{type:"integer"}}],responses:{200:{description:"Offers retrieved successfully."},500:query_1.serverErrorResponse}};exports.default=async(e={})=>{const{limit:r}=e.query||{},{ctx:t}=e||{},s=parseInt(r,10)>0?parseInt(r,10):10;null==t||t.step(`Calculating popularity for top ${s} offers`);try{const e="\n      SELECT\n        o.*,\n        COUNT(t.id) AS tradeCount,\n        AVG((r.communicationRating + r.speedRating + r.trustRating)/3) AS averageRating,\n        (COUNT(t.id) * 0.7 + COALESCE(AVG((r.communicationRating + r.speedRating + r.trustRating)/3), 0) * 0.3) AS popularityScore\n      FROM p2p_offers o\n      LEFT JOIN p2p_trades t ON o.id = t.offerId AND t.status = 'COMPLETED'\n      LEFT JOIN p2p_reviews r ON t.id = r.tradeId\n      GROUP BY o.id\n      ORDER BY popularityScore DESC\n      LIMIT :limit\n    ",r=await db_1.sequelize.query(e,{replacements:{limit:s},type:sequelize_1.QueryTypes.SELECT});null==t||t.success(`Retrieved ${r.length} popular offers`);return r}catch(e){null==t||t.fail(e.message||"Failed to retrieve popular offers");throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error: "+e.message})}};