"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),sequelize_1=require("sequelize"),error_1=require("@b/utils/error");exports.metadata={summary:"Get Top Cryptocurrencies in P2P",description:"Retrieves the top cryptocurrencies based on trade volume aggregations.",operationId:"getP2PTopCryptos",tags:["P2P","Market"],logModule:"P2P",logTitle:"Get top cryptocurrencies",responses:{200:{description:"Top cryptocurrencies retrieved successfully."},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!1};exports.default=async e=>{const{ctx:r}=e||{};null==r||r.step("Calculating top cryptocurrencies");try{const e=await db_1.models.p2pTrade.findAll({attributes:["currency",[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("total")),"totalVolume"]],group:["currency"],order:[[(0,sequelize_1.literal)("totalVolume"),"DESC"]],limit:5,raw:!0});null==r||r.success(`Retrieved ${e.length} top cryptocurrencies`);return e}catch(e){null==r||r.fail(e.message||"Failed to retrieve top cryptocurrencies");throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error: "+e.message})}};