"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),error_1=require("@b/utils/error");exports.metadata={summary:"List Distinct Countries from User Profiles",description:"Retrieves a list of distinct countries extracted from user profile locations.",operationId:"listUserCountries",tags:["User","Countries"],logModule:"P2P",logTitle:"Get user countries",responses:{200:{description:"List of countries retrieved successfully."},500:query_1.serverErrorResponse}};exports.default=async e=>{const{ctx:r}=e||{};null==r||r.step("Querying distinct countries");try{const[e]=await db_1.sequelize.query("\n      SELECT DISTINCT\n        JSON_UNQUOTE(JSON_EXTRACT(profile, '$.location.country')) AS country\n      FROM user\n      WHERE profile IS NOT NULL\n        AND JSON_EXTRACT(profile, '$.location.country') IS NOT NULL\n      ORDER BY country\n    ");null==r||r.success(`Retrieved ${e.length} countries`);return e}catch(e){null==r||r.fail(e.message||"Failed to retrieve countries");throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error: "+e.message})}};