"use strict";function getTimeAgo(e){const t=Math.floor(((new Date).getTime()-e.getTime())/1e3);if(t<60)return`${t}s ago`;const a=Math.floor(t/60);if(a<60)return`${a}m ago`;const r=Math.floor(a/60);if(r<24)return`${r}h ago`;return`${Math.floor(r/24)}d ago`}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),json_safe_1=require("../utils/json-safe");exports.metadata={summary:"Get P2P Landing Page Data",description:"Retrieves comprehensive data for the P2P landing page including stats, top cryptos, featured offers, top traders, and payment methods.",operationId:"getP2PLandingData",tags:["P2P","Landing"],requiresAuth:!1,responses:{200:{description:"P2P landing data retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{stats:{type:"object"},topCryptos:{type:"array"},featuredOffers:{type:"object"},topTraders:{type:"array"},popularPaymentMethods:{type:"array"},recentActivity:{type:"array"},trustMetrics:{type:"object"}}}}}}}};exports.default=async()=>{const e=new Date,t=new Date(e.getFullYear(),e.getMonth(),1),a=new Date(e.getFullYear(),e.getMonth()-1,1),r=new Date(e.getFullYear(),e.getMonth(),0),[l,i,s,o,n,u,d,p,c,m]=await Promise.all([db_1.models.p2pTrade.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"totalTrades"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN status = 'COMPLETED' THEN 1 ELSE 0 END")),"completedTrades"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN status = 'COMPLETED' THEN total ELSE 0 END")),"totalVolume"],[(0,sequelize_1.fn)("AVG",(0,sequelize_1.literal)("CASE WHEN status = 'COMPLETED' THEN total ELSE NULL END")),"avgTradeSize"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("DISTINCT buyerId")),"uniqueBuyers"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("DISTINCT sellerId")),"uniqueSellers"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN status = 'COMPLETED' AND createdAt >= '${t.toISOString()}' THEN total ELSE 0 END`)),"currentVolume"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN status = 'COMPLETED' AND createdAt BETWEEN '${a.toISOString()}' AND '${r.toISOString()}' THEN total ELSE 0 END`)),"previousVolume"]],raw:!0}),db_1.models.p2pTrade.findAll({attributes:["currency",[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("total")),"totalVolume"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"tradeCount"],[(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("price")),"avgPrice"]],where:{status:"COMPLETED"},group:["currency"],order:[[(0,sequelize_1.literal)("totalVolume"),"DESC"]],limit:6,raw:!0}),db_1.models.p2pOffer.findAll({where:{type:"SELL",status:"ACTIVE"},include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","avatar"]},{model:db_1.models.p2pPaymentMethod,as:"paymentMethods",attributes:["id","name","icon"],through:{attributes:[]}}],order:[["createdAt","DESC"]],limit:4}),db_1.models.p2pOffer.findAll({where:{type:"BUY",status:"ACTIVE"},include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","avatar"]},{model:db_1.models.p2pPaymentMethod,as:"paymentMethods",attributes:["id","name","icon"],through:{attributes:[]}}],order:[["createdAt","DESC"]],limit:4}),db_1.models.p2pReview.findAll({attributes:["revieweeId",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"reviewCount"],[(0,sequelize_1.fn)("AVG",(0,sequelize_1.literal)("(communicationRating + speedRating + trustRating) / 3")),"avgRating"],[(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("communicationRating")),"avgCommunicationRating"],[(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("speedRating")),"avgSpeedRating"],[(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("trustRating")),"avgTrustRating"]],group:["revieweeId"],having:(0,sequelize_1.literal)("COUNT(id) >= 3"),order:[[(0,sequelize_1.literal)("avgRating"),"DESC"]],limit:6,raw:!0}),db_1.models.p2pPaymentMethod.findAll({where:{isGlobal:!0,available:!0},attributes:["id","name","icon","processingTime"],order:[["popularityRank","DESC"]],limit:8}),db_1.models.p2pTrade.findAll({where:{status:"COMPLETED"},attributes:["currency","amount","total","createdAt"],order:[["createdAt","DESC"]],limit:10,raw:!0}),db_1.models.p2pDispute.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"totalDisputes"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN status = 'RESOLVED' THEN 1 ELSE 0 END")),"resolvedDisputes"]],raw:!0}),db_1.models.p2pOffer.count({where:{status:"ACTIVE"}}),db_1.models.p2pOffer.findAll({attributes:[[(0,sequelize_1.fn)("DISTINCT",(0,sequelize_1.literal)("JSON_EXTRACT(locationSettings, '$.country')")),"country"]],where:{status:"ACTIVE",locationSettings:{[sequelize_1.Op.ne]:null}},raw:!0})]),f=parseInt(null==l?void 0:l.totalTrades)||0,g=parseInt(null==l?void 0:l.completedTrades)||0,v=parseFloat(null==l?void 0:l.totalVolume)||0,_=parseFloat(null==l?void 0:l.avgTradeSize)||0,E=f>0?Math.round(g/f*100):0,T=(parseInt(null==l?void 0:l.uniqueBuyers)||0)+(parseInt(null==l?void 0:l.uniqueSellers)||0),q=parseFloat(null==l?void 0:l.currentVolume)||0,y=parseFloat(null==l?void 0:l.previousVolume)||0,z=y>0?Math.round((q-y)/y*100):0,C=m.filter(e=>e.country&&"null"!==e.country).length,S=n.map(e=>e.revieweeId),A=S.length>0?await db_1.models.user.findAll({where:{id:{[sequelize_1.Op.in]:S}},attributes:["id","firstName","lastName","avatar","createdAt"]}):[],N={};A.forEach(e=>{N[e.id]=e});const b=S.length>0?await db_1.models.p2pTrade.findAll({attributes:["sellerId",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"tradeCount"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("total")),"totalVolume"]],where:{status:"COMPLETED",sellerId:{[sequelize_1.Op.in]:S}},group:["sellerId"],raw:!0}):[],h={};b.forEach(e=>{h[e.sellerId]=e});const D=n.map(e=>{const t=N[e.revieweeId],a=h[e.revieweeId]||{};return{id:e.revieweeId,firstName:(null==t?void 0:t.firstName)||"Trader",lastName:(null==t?void 0:t.lastName)||"",avatar:(null==t?void 0:t.avatar)||null,completedTrades:parseInt(a.tradeCount)||0,totalVolume:parseFloat(a.totalVolume)||0,successRate:100,avgRating:parseFloat(e.avgRating)||0,avgCommunicationRating:parseFloat(e.avgCommunicationRating)||0,avgSpeedRating:parseFloat(e.avgSpeedRating)||0,avgTrustRating:parseFloat(e.avgTrustRating)||0,memberSince:null==t?void 0:t.createdAt}}),M=e=>{var t,a,r;const l=(0,json_safe_1.safeParse)(e.priceConfig,{}),i=(0,json_safe_1.safeParse)(e.amountConfig,{}),s=(0,json_safe_1.safeParse)(e.tradeSettings,{});return{id:e.id,currency:e.currency,priceCurrency:e.priceCurrency||(null==l?void 0:l.currency)||"USD",price:(null==l?void 0:l.finalPrice)||(null==l?void 0:l.fixedPrice)||(null==l?void 0:l.value)||0,priceModel:(null==l?void 0:l.model)||"FIXED",minAmount:(null==i?void 0:i.min)||0,maxAmount:(null==i?void 0:i.max)||(null==i?void 0:i.total)||0,availableAmount:(null==i?void 0:i.availableBalance)||(null==i?void 0:i.total)||0,termsOfTrade:(null==s?void 0:s.termsOfTrade)||"",trader:{id:null===(t=e.user)||void 0===t?void 0:t.id,firstName:(null===(a=e.user)||void 0===a?void 0:a.firstName)||"Trader",avatar:null===(r=e.user)||void 0===r?void 0:r.avatar}}},w=d.map(e=>{const t=getTimeAgo(new Date(e.createdAt));return{type:"TRADE_COMPLETED",currency:e.currency,amount:e.amount,total:e.total,timeAgo:t}}),O=parseInt(null==p?void 0:p.totalDisputes)||0,I=parseInt(null==p?void 0:p.resolvedDisputes)||0,P=O>0?Math.round(I/O*100):100,R=g>0?Math.round(O/g*100*10)/10:0;return{stats:{totalTrades:f,completedTrades:g,totalVolume:v,averageTradeSize:_,successRate:E,uniqueTraders:T,activeOffers:c,avgCompletionTime:15,disputeResolutionRate:P,countriesServed:C||50,volumeGrowth:z,tradersGrowth:0,offersGrowth:0},topCryptos:i.map(e=>({currency:e.currency,totalVolume:parseFloat(e.totalVolume)||0,tradeCount:parseInt(e.tradeCount)||0,avgPrice:parseFloat(e.avgPrice)||0})),featuredOffers:{buy:s.map(M),sell:o.map(M)},topTraders:D,popularPaymentMethods:u.map(e=>({id:e.id,name:e.name,icon:e.icon,processingTime:e.processingTime})),recentActivity:w,trustMetrics:{avgEscrowReleaseTime:15,disputeRate:R,disputeResolutionRate:P,satisfactionRate:95}}};