"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),query_1=require("@b/utils/query"),utils_1=require("@b/api/finance/currency/utils"),console_1=require("@b/utils/console");exports.metadata={summary:"Get P2P Dashboard Stats",description:"Retrieves various trade counts and stats for the authenticated user.",operationId:"getP2PDashboardStats",tags:["P2P","Dashboard"],logModule:"P2P",logTitle:"Get dashboard stats",responses:{200:{description:"Dashboard stats retrieved successfully."},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:t,ctx:r}=e;if(!(null==t?void 0:t.id))return{statusCode:401,message:"Unauthorized"};null==r||r.step("Validating P2P extension");try{if(!db_1.models.p2pTrade)return{statusCode:500,message:"P2P extension is not properly installed or configured"};let e=0,a=0,s=0,o=[];null==r||r.step("Fetching trade statistics");try{e=await db_1.models.p2pTrade.count({where:{[sequelize_1.Op.or]:[{buyerId:t.id},{sellerId:t.id}]}})}catch(e){console_1.logger.error("P2P",`Error fetching total trades: ${e}`)}try{a=await db_1.models.p2pTrade.count({where:{status:"PENDING",[sequelize_1.Op.or]:[{buyerId:t.id},{sellerId:t.id}]}})}catch(e){console_1.logger.error("P2P",`Error fetching active trades: ${e}`)}try{s=await db_1.models.p2pTrade.count({where:{status:"COMPLETED",[sequelize_1.Op.or]:[{buyerId:t.id},{sellerId:t.id}]}})}catch(e){console_1.logger.error("P2P",`Error fetching completed trades: ${e}`)}null==r||r.step("Fetching user wallets");try{o=await db_1.models.wallet.findAll({where:{userId:t.id,type:{[sequelize_1.Op.in]:["FIAT","SPOT","ECO"]}},attributes:["id","type","currency","balance","inOrder","status"],raw:!0})}catch(e){console_1.logger.error("P2P",`Error fetching user wallets: ${e}`);o=[]}null==r||r.step("Calculating total balance");let l=0;for(const e of o)try{const t=parseFloat(e.balance||0)-parseFloat(e.inOrder||0);if(t<=0)continue;let r=1;if("USD"===e.currency){l+=t;continue}try{switch(e.type){case"FIAT":r=await(0,utils_1.getFiatPriceInUSD)(e.currency);break;case"SPOT":r=await(0,utils_1.getSpotPriceInUSD)(e.currency);break;case"ECO":r=await(0,utils_1.getEcoPriceInUSD)(e.currency)}}catch(t){console_1.logger.error("P2P",`Error getting price for ${e.type} ${e.currency}: ${t}`);continue}l+=t*r}catch(t){console_1.logger.error("P2P",`Error processing wallet ${e.id}: ${t}`)}const i=e>0?Math.round(s/e*100):0,n={stats:[{title:"Total Balance",value:`$${l.toFixed(2)}`,change:`${o.length} wallet${1!==o.length?"s":""} available`,changeType:"neutral",icon:"wallet",gradient:"from-blue-500 to-blue-700"},{title:"Trading Volume",value:`$${l.toFixed(2)}`,change:`${e} total trade${1!==e?"s":""}`,changeType:e>0?"positive":"neutral",icon:"trending-up",gradient:"from-green-500 to-green-700"},{title:"Active Trades",value:a.toString(),change:`${a} pending completion`,changeType:a>0?"positive":"neutral",icon:"bar-chart",gradient:"from-violet-500 to-violet-700"},{title:"Success Rate",value:`${i}%`,change:`Based on ${e} trade${1!==e?"s":""}`,changeType:i>=80?"positive":i>=50?"neutral":"negative",icon:"shield-check",gradient:"from-amber-500 to-amber-700"}],totalTrades:e,activeTrades:a,completedTrades:s,wallets:o.map(e=>({id:e.id,type:e.type,currency:e.currency,balance:parseFloat(e.balance||0),inOrder:parseFloat(e.inOrder||0),availableBalance:parseFloat(e.balance||0)-parseFloat(e.inOrder||0),status:e.status}))};null==r||r.success(`Stats retrieved (${e} total trades, ${s} completed)`);return n}catch(e){console_1.logger.error("P2P",`Dashboard Stats API Error: ${e.message}`);null==r||r.fail(e.message||"Failed to retrieve dashboard stats");return{statusCode:500,message:"Internal Server Error: "+e.message}}};