"use strict";function validateWalletAddress(e,t){const a={ethereum:/^0x[a-fA-F0-9]{40}$/,bsc:/^0x[a-fA-F0-9]{40}$/,polygon:/^0x[a-fA-F0-9]{40}$/,bitcoin:/^[13][a-km-zA-HJ-NP-Z1-9]{25,34}$/,solana:/^[1-9A-HJ-NP-Za-km-z]{32,44}$/}[t.toLowerCase()];return!a||a.test(e)}async function getInvestmentLimits(){const e=(await db_1.models.settings.findAll({where:{key:{[sequelize_1.Op.in]:["icoMinInvestment","icoMaxInvestment","icoMaxPerUser"]}}})).reduce((e,t)=>{e[t.key]=parseFloat(t.value)||0;return e},{});return{minInvestment:e.icoMinInvestment||10,maxInvestment:e.icoMaxInvestment||1e5,maxPerUser:e.icoMaxPerUser||5e4}}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),crypto_1=__importDefault(require("crypto")),utils_1=require("@b/api/(ext)/admin/ico/utils"),notifications_1=require("@b/utils/notifications"),Middleware_1=require("@b/handler/Middleware"),sequelize_1=require("sequelize"),console_1=require("@b/utils/console"),wallet_1=require("@b/services/wallet"),affiliate_1=require("@b/utils/affiliate");exports.metadata={summary:"Create a New ICO Investment",description:"Creates a new ICO investment transaction for the authenticated user using icoTransaction only. The wallet type and currency are derived from the associated plan. It also deducts funds from the user's wallet, records the transaction, updates offering stats, and sends email and in‑app notifications to both investor and seller.",operationId:"createIcoInvestment",tags:["ICO","Investments"],requiresAuth:!0,logModule:"ICO_INVESTMENT",logTitle:"Purchase ICO tokens",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{offeringId:{type:"string",description:"ICO offering ID"},amount:{type:"number",description:"Investment amount"},walletAddress:{type:"string",description:"Wallet address where tokens will be sent"}},required:["offeringId","amount","walletAddress"]}}}},responses:{200:{description:"ICO investment transaction created successfully.",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"},transactionId:{type:"string",description:"Transaction ID"},tokenAmount:{type:"number",description:"Number of tokens purchased"}}}}}},400:{description:"Missing required fields or insufficient balance."},401:{description:"Unauthorized."},500:{description:"Internal Server Error."}}};exports.default=async e=>{await Middleware_1.rateLimiters.orderCreation(e);const{body:t,user:a,ctx:r}=e;if(!(null==a?void 0:a.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==r||r.step("Validating purchase request");const{offeringId:n,amount:i,walletAddress:s}=t;if(!n||!i||!s)throw(0,error_1.createError)({statusCode:400,message:"Missing required fields"});if(!Number.isFinite(i)||i<=0)throw(0,error_1.createError)({statusCode:400,message:"Invalid investment amount"});const o=await db_1.sequelize.transaction();try{null==r||r.step("Retrieving ICO offering details");const e=await db_1.models.icoTokenOffering.findByPk(n,{include:[{model:db_1.models.icoTokenDetail,as:"tokenDetail",required:!0}],transaction:o,lock:o.LOCK.UPDATE});if(!e)throw(0,error_1.createError)({statusCode:404,message:"Offering not found"});null==r||r.step("Validating offering status and eligibility");if("ACTIVE"!==e.status)throw(0,error_1.createError)({statusCode:400,message:`Offering is ${e.status.toLowerCase()}. Only active offerings can receive investments.`});const t=new Date;if(t<e.startDate)throw(0,error_1.createError)({statusCode:400,message:"Offering has not started yet"});if(t>e.endDate)throw(0,error_1.createError)({statusCode:400,message:"Offering has ended"});const l=e.tokenDetail.blockchain;if(!validateWalletAddress(s,l))throw(0,error_1.createError)({statusCode:400,message:`Invalid ${l} wallet address format`});null==r||r.step("Checking investment limits and user eligibility");const c=await getInvestmentLimits();if(i<c.minInvestment)throw(0,error_1.createError)({statusCode:400,message:`Minimum investment is ${c.minInvestment} ${e.purchaseWalletCurrency}`});if(i>c.maxInvestment)throw(0,error_1.createError)({statusCode:400,message:`Maximum investment is ${c.maxInvestment} ${e.purchaseWalletCurrency}`});const d=await db_1.models.icoTransaction.findAll({where:{userId:a.id,offeringId:e.id,status:{[sequelize_1.Op.in]:["PENDING","VERIFICATION","RELEASED"]}},transaction:o}),u=d.reduce((e,t)=>e+t.amount*t.price,0);if(u+i>c.maxPerUser)throw(0,error_1.createError)({statusCode:400,message:`Maximum investment per user is ${c.maxPerUser} ${e.purchaseWalletCurrency}. You have already invested ${u}.`});null==r||r.step("Finding active phase and calculating token amount");const m=await db_1.models.icoTokenOfferingPhase.findOne({where:{offeringId:e.id,remaining:{[sequelize_1.Op.gt]:0}},order:[["sequence","ASC"]],transaction:o,lock:o.LOCK.UPDATE});if(!m)throw(0,error_1.createError)({statusCode:400,message:"No tokens available for sale"});const f=m.tokenPrice,p=await db_1.models.ecosystemToken.findOne({where:{currency:e.symbol,chain:l.toLowerCase()},transaction:o}),I=(null==p?void 0:p.decimals)||18,g=i/f*Math.pow(10,I),h=i/f;if(h>m.remaining)throw(0,error_1.createError)({statusCode:400,message:`Only ${m.remaining} tokens remaining in current phase`});const w=await db_1.models.icoTransaction.sum("amount",{where:{offeringId:e.id,status:{[sequelize_1.Op.in]:["PENDING","VERIFICATION","RELEASED"]}},transaction:o})||0;if(w+i>e.targetAmount){const t=e.targetAmount-w;throw(0,error_1.createError)({statusCode:400,message:`Investment exceeds target amount. Only ${t} ${e.purchaseWalletCurrency} remaining.`})}null==r||r.step("Verifying wallet balance");const _=await db_1.models.wallet.findOne({where:{userId:a.id,type:e.purchaseWalletType,currency:e.purchaseWalletCurrency},transaction:o,lock:o.LOCK.UPDATE});if(!_)throw(0,error_1.createError)({statusCode:400,message:`No ${e.purchaseWalletType} wallet found for ${e.purchaseWalletCurrency}. Please create a wallet first.`});const y=_.balance||0;if(y<i)throw(0,error_1.createError)({statusCode:400,message:`Insufficient wallet balance. Required: ${i} ${e.purchaseWalletCurrency}, Available: ${y} ${e.purchaseWalletCurrency}`});null==r||r.step("Deducting payment from wallet");const C=`ico_invest_${n}_${a.id}_${i}`,N=await wallet_1.walletService.debit({idempotencyKey:C,userId:a.id,walletId:_.id,walletType:e.purchaseWalletType,currency:e.purchaseWalletCurrency,amount:i,operationType:"ICO_CONTRIBUTION",description:`ICO Investment in ${e.name} - ${h} tokens at ${f} ${e.purchaseWalletCurrency} each`,metadata:{offeringId:e.id,offeringName:e.name,phase:m.name,tokenAmount:h,tokenPrice:f,walletAddress:s},transaction:o});null==r||r.step("Allocating tokens and creating ICO transaction record");const v=crypto_1.default.randomBytes(16).toString("hex");await db_1.models.icoTransaction.create({userId:a.id,offeringId:e.id,amount:h,price:f,status:"PENDING",transactionId:v,walletAddress:s,notes:JSON.stringify({phase:m.name,decimals:I,rawTokenAmount:g.toString(),investmentAmount:i,currency:e.purchaseWalletCurrency,walletTransactionId:N.transactionId})},{transaction:o});null==r||r.step("Updating phase and offering statistics");await m.update({remaining:m.remaining-h},{transaction:o});0===d.length&&await e.update({participants:e.participants+1},{transaction:o});await db_1.models.icoAdminActivity.create({type:"INVESTMENT_CREATED",offeringId:e.id,offeringName:e.name,adminId:a.id,details:JSON.stringify({investor:a.email,amount:i,tokenAmount:h,phase:m.name,walletAddress:s})},{transaction:o});await o.commit();null==r||r.step("Sending email and in-app notifications");a.email&&await(0,utils_1.sendIcoBuyerEmail)(a.email,{INVESTOR_NAME:`${a.firstName} ${a.lastName}`,OFFERING_NAME:e.name,AMOUNT_INVESTED:i.toFixed(2),TOKEN_AMOUNT:h.toFixed(4),TOKEN_PRICE:f.toFixed(4),TRANSACTION_ID:v},r);const O=await db_1.models.user.findByPk(e.userId);O&&O.email&&await(0,utils_1.sendIcoSellerEmail)(O.email,{SELLER_NAME:`${O.firstName} ${O.lastName}`,OFFERING_NAME:e.name,INVESTOR_NAME:`${a.firstName} ${a.lastName}`,AMOUNT_INVESTED:i.toFixed(2),TOKEN_AMOUNT:h.toFixed(4),TRANSACTION_ID:v},r);try{await(0,notifications_1.createNotification)({userId:a.id,relatedId:e.id,type:"investment",title:"Investment Confirmed",message:`Your investment of ${i} ${e.purchaseWalletCurrency} in ${e.name} has been confirmed.`,details:`You have purchased ${h.toFixed(4)} tokens at ${f} ${e.purchaseWalletCurrency} per token. Transaction ID: ${v}`,link:"/ico/dashboard?tab=transactions",actions:[{label:"View Transaction",link:"/ico/dashboard?tab=transactions",primary:!0}]},r)}catch(e){console_1.logger.error("ICO_TRANSACTION","Failed to create in-app notification for buyer",e)}try{await(0,notifications_1.createNotification)({userId:e.userId,relatedId:e.id,type:"system",title:"New Investment Received",message:`New investment of ${i} ${e.purchaseWalletCurrency} in ${e.name}`,details:`Investor: ${a.firstName} ${a.lastName}\nAmount: ${i} ${e.purchaseWalletCurrency}\nTokens: ${h.toFixed(4)}\nPhase: ${m.name}`,link:`/ico/creator/token/${e.id}?tab=transactions`,actions:[{label:"View Details",link:`/ico/creator/token/${e.id}?tab=transactions`,primary:!0}]},r)}catch(e){console_1.logger.error("ICO_TRANSACTION","Failed to create in-app notification for seller",e)}null==r||r.success(`Purchased ${h.toFixed(4)} tokens for ${i} ${e.purchaseWalletCurrency}`);try{await(0,affiliate_1.processRewards)(a.id,i,"ICO_CONTRIBUTION",e.purchaseWalletCurrency)}catch(e){console_1.logger.error("ICO_TRANSACTION","Failed to process affiliate rewards",e)}return{message:"ICO investment transaction created successfully.",transactionId:v,tokenAmount:h}}catch(e){await o.rollback();null==r||r.fail(e.message||"Failed to process ICO investment");throw e}};