"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize");exports.metadata={summary:"Get ICO Offerings by Status",description:"Retrieves ICO token offerings filtered by a given status and additional query parameters such as pagination, search, sort, blockchain, tokenType. If the status is 'COMPLETED', the endpoint returns offerings with statuses 'SUCCESS' and 'FAILED'.",operationId:"getIcoOfferingsByStatus",tags:["ICO","Offerings"],logModule:"ICO",logTitle:"Get ICO Offers",parameters:[{index:1,name:"status",in:"query",description:"The offering status to filter by (e.g., ACTIVE, UPCOMING, COMPLETED). Use COMPLETED to fetch offerings with SUCCESS or FAILED status.",required:!1,schema:{type:"string"}},{index:2,name:"page",in:"query",description:"Page number for pagination.",required:!1,schema:{type:"number"}},{index:3,name:"limit",in:"query",description:"Number of items per page for pagination.",required:!1,schema:{type:"number"}},{index:4,name:"search",in:"query",description:"Search term to filter offerings by name or symbol.",required:!1,schema:{type:"string"}},{index:5,name:"sort",in:"query",description:"Sort option for offerings. Valid values: newest, oldest, raised-high, raised-low, target-high, target-low, ending-soon.",required:!1,schema:{type:"string"}},{index:6,name:"blockchain",in:"query",description:"Filter by blockchain. Accepts one or more values (e.g., Ethereum, Solana, Polygon, Binance Smart Chain).",required:!1,schema:{type:"string"},style:"form",explode:!0},{index:7,name:"tokenType",in:"query",description:"Filter by token type. Accepts one or more values (e.g., Utility, Security, Governance).",required:!1,schema:{type:"string"},style:"form",explode:!0}],responses:{200:{description:"ICO offerings retrieved successfully.",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object",properties:{id:{type:"string",description:"Unique identifier for the offering"},name:{type:"string",description:"Name of the offering"},ticker:{type:"string",description:"Token ticker"},description:{type:"string",description:"Detailed description of the offering"},status:{type:"string",description:"Current status (ACTIVE, PENDING, etc.). For COMPLETED queries, the status may be SUCCESS or FAILED."},tokenPrice:{type:"number",description:"Current token price"},targetAmount:{type:"number",description:"Total funding target"},participants:{type:"number",description:"Number of participants"},isPaused:{type:"boolean",description:"Flag if the offering is paused"},isFlagged:{type:"boolean",description:"Flag if the offering is flagged"},startDate:{type:"string",format:"date-time",description:"Start date of the offering"},endDate:{type:"string",format:"date-time",description:"End date of the offering"},currentPhase:{type:"object",description:"Information about the current phase",properties:{name:{type:"string",description:"Name of the current phase"},tokenPrice:{type:"number",description:"Token price in the current phase"},allocation:{type:"number",description:"Total allocation in the phase"},remaining:{type:"number",description:"Remaining tokens in the phase"},endsIn:{type:"number",description:"Days until the phase ends (calculated dynamically)"}}},nextPhase:{type:"object",description:"Information about the next phase",properties:{name:{type:"string",description:"Name of the next phase"},tokenPrice:{type:"number",description:"Token price in the next phase"},allocation:{type:"number",description:"Total allocation in the phase"},remaining:{type:"number",description:"Remaining tokens in the phase"},endsIn:{type:"number",description:"Days until the phase ends (using its full duration)"}}},phases:{type:"array",description:"List of all phases for the offering",items:{type:"object",properties:{name:{type:"string",description:"Phase name"},tokenPrice:{type:"number",description:"Token price during the phase"},allocation:{type:"number",description:"Total allocation for the phase"},remaining:{type:"number",description:"Remaining tokens for the phase"},duration:{type:"number",description:"Duration in days for the phase"}}}},tokenDetail:{type:"object",description:"Detailed token information"},teamMembers:{type:"array",description:"List of team members",items:{type:"object"}},roadmapItems:{type:"array",description:"List of roadmap items",items:{type:"object"}},currentRaised:{type:"number",description:"Sum of all transactions (price * amount) associated with this offering"}}}},pagination:{type:"object",properties:{currentPage:{type:"number"},totalPages:{type:"number"},totalItems:{type:"number"}}}}}}}},500:{description:"Internal Server Error."}}};exports.default=async e=>{try{const{ctx:t}=e||{};null==t||t.step("Fetching get ico offers");const{query:i}=e||{},r=(null==i?void 0:i.status)?i.status.toUpperCase():"PENDING",n=i.page?parseInt(i.page):1,s=i.limit?parseInt(i.limit):10,a=(n-1)*s,o=i.sort||"newest",p={};p.status="COMPLETED"===r?{[sequelize_1.Op.in]:["SUCCESS","FAILED"]}:r;if(i.search){const e=i.search;p[sequelize_1.Op.or]=[{name:{[sequelize_1.Op.like]:`%${e}%`}},{symbol:{[sequelize_1.Op.like]:`%${e}%`}}]}const c={};if(i.blockchain){const e=Array.isArray(i.blockchain)?i.blockchain:[i.blockchain];c.blockchain={[sequelize_1.Op.in]:e}}if(i.tokenType){const e=Array.isArray(i.tokenType)?i.tokenType:[i.tokenType];c.tokenType={[sequelize_1.Op.in]:e}}Object.keys(c).forEach(e=>{p[`$tokenDetail.${e}$`]=c[e]});const d=[];switch(o){case"newest":default:d.push(["createdAt","DESC"]);break;case"oldest":d.push(["createdAt","ASC"]);break;case"target-high":d.push(["targetAmount","DESC"]);break;case"target-low":d.push(["targetAmount","ASC"]);break;case"ending-soon":d.push(["endDate","ASC"])}const{count:l,rows:u}=await db_1.models.icoTokenOffering.findAndCountAll({where:p,include:[{model:db_1.models.icoTokenOfferingPhase,as:"phases"},{model:db_1.models.icoTokenDetail,as:"tokenDetail",required:Object.keys(c).length>0},{model:db_1.models.icoTeamMember,as:"teamMembers"},{model:db_1.models.icoRoadmapItem,as:"roadmapItems"}],limit:s,offset:a,order:d}),m=u.map(e=>e.id),f=await db_1.models.icoTransaction.findAll({attributes:["offeringId",[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("price * amount")),"currentRaised"]],where:{offeringId:{[sequelize_1.Op.in]:m},status:{[sequelize_1.Op.not]:["REJECTED"]}},group:["offeringId"]}),h={};f.forEach(e=>{const t=e.get("offeringId"),i=e.get("currentRaised");h[t]=i?Number(i):0});const y=new Date,g=u.map(e=>{const t=e.phases||[];let i=0,r=null,n=null;const s=new Date(e.startDate),a=Math.floor((y.getTime()-s.getTime())/864e5);for(let e=0;e<t.length;e++){i+=t[e].duration;if(a<i){const s=i-a;r={...t[e].toJSON(),endsIn:s};e+1<t.length&&(n={...t[e+1].toJSON(),endsIn:t[e+1].duration});break}}return{id:e.id,name:e.name,icon:e.icon,purchaseWalletCurrency:e.purchaseWalletCurrency,purchaseWalletType:e.purchaseWalletType,symbol:e.symbol,status:e.status,tokenPrice:e.tokenPrice,targetAmount:e.targetAmount,participants:e.participants,isPaused:e.isPaused,isFlagged:e.isFlagged,startDate:e.startDate,endDate:e.endDate,currentPhase:r,nextPhase:n,phases:t.map(e=>e.toJSON()),tokenDetail:e.tokenDetail?e.tokenDetail.toJSON():null,teamMembers:e.teamMembers?e.teamMembers.map(e=>e.toJSON()):[],roadmapItems:e.roadmapItems?e.roadmapItems.map(e=>e.toJSON()):[],currentRaised:h[e.id]||0}});null==t||t.success("Get ICO Offers retrieved successfully");return{items:g,pagination:{currentPage:n,totalPages:Math.ceil(l/s),totalItems:l,total:l}}}catch(e){console.error("Error in getIcoOfferingsByStatus:",e);throw e}};