"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),notifications_1=require("@b/utils/notifications");exports.metadata={summary:"Create a Token Offering Update",description:"Creates a new update for a token offering by the authenticated creator.",operationId:"createTokenOfferingUpdate",tags:["ICO","Creator","Updates"],requiresAuth:!0,logModule:"ICO_UPDATE",logTitle:"Create offering update",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{tokenId:{type:"string",description:"Token offering ID"},title:{type:"string"},content:{type:"string"},attachments:{type:"array",items:{type:"object",properties:{type:{type:"string",enum:["image","document","link"]},url:{type:"string"},name:{type:"string"}}}}},required:["tokenId","title","content"]}}}},responses:{200:{description:"Token offering update created successfully.",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},update:{type:"object"}}}}}},400:{description:"Bad Request"},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{user:t,body:r,ctx:o}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==o||o.step("Validating update request");const{tokenId:i,title:a,content:n,attachments:s}=r;if(!i||!a||!n)throw(0,error_1.createError)({statusCode:400,message:"Missing required fields"});null==o||o.step("Creating offering update");const d=await db_1.models.icoTokenOfferingUpdate.create({offeringId:i,userId:t.id,title:a,content:n,attachments:s||[]});null==o||o.step("Sending notification");try{await(0,notifications_1.createNotification)({userId:t.id,relatedId:i,type:"system",title:"New Update Created",message:`New update "${a}" created successfully.`,details:"Your token offering update has been posted and is now visible to your investors.",link:`/ico/creator/token/${i}?tab=updates`,actions:[{label:"View Update",link:`/ico/creator/token/${i}?tab=updates`,primary:!0}]})}catch(e){console.error("Failed to create notification for update creation",e)}null==o||o.success(`Created update "${a}"`);return{message:"Update created successfully.",update:d}};