"use strict";async function getCreatorDailyChartData(e,t,r){const a="DATE_FORMAT(icoTransaction.createdAt, '%Y-%m-%d')",o=await db_1.models.icoTransaction.findAll({attributes:[[(0,sequelize_1.literal)(a),"period"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("amount * price")),"raised"]],include:[{model:db_1.models.icoTokenOffering,as:"offering",attributes:[],where:{userId:e}}],where:{createdAt:{[sequelize_1.Op.between]:[t,r]},status:{[sequelize_1.Op.in]:["PENDING","RELEASED"]}},group:[(0,sequelize_1.literal)(a)],order:[(0,sequelize_1.literal)("period")],raw:!0}),n=[];for(let e=new Date(t);e<=r;e.setDate(e.getDate()+1)){const t=formatDate(e),r=o.find(e=>e.period===t);n.push({date:t,amount:r?parseFloat(r.raised):0})}return n}async function getCreatorMonthlyChartData(e,t,r){const a="DATE_FORMAT(icoTransaction.createdAt, '%Y-%m-01')",o=await db_1.models.icoTransaction.findAll({attributes:[[(0,sequelize_1.literal)(a),"period"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("amount * price")),"raised"]],include:[{model:db_1.models.icoTokenOffering,as:"offering",attributes:[],where:{userId:e}}],where:{createdAt:{[sequelize_1.Op.gte]:t},status:{[sequelize_1.Op.not]:["REJECTED"]}},group:[(0,sequelize_1.literal)(a)],order:[(0,sequelize_1.literal)("period")],raw:!0}),n=[],i=new Date(t);for(;i<=r;){const e=formatMonth(i),t=o.find(t=>t.period===e);n.push({date:e,amount:t?parseFloat(t.raised):0});i.setMonth(i.getMonth()+1)}for(;n.length<12;){const e=new Date(n[0].date);e.setMonth(e.getMonth()-1);n.unshift({date:formatMonth(e),amount:0})}return n}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Creator Chart Data",description:"Retrieves chart data (daily, weekly, or monthly performance) for the authenticated creator's ICO offerings based on a specified time range.",operationId:"getCreatorStatsChart",tags:["ICO","Creator","Stats"],logModule:"ICO",logTitle:"Get Creator Performance",requiresAuth:!0,parameters:[{index:0,name:"range",in:"query",description:"Time range for chart data: '7d' for current week (Monday–Sunday), '30d' for current month (daily), '90d' for 3 full months (from start of two months before current month till end of current month), or 'all' for all time (monthly, extended to at least 12 months).",required:!0,schema:{type:"string"}}],responses:{200:{description:"Creator chart data retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{date:{type:"string",description:"Date in YYYY-MM-DD format"},amount:{type:"number",description:"Amount raised for that period"}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal server error"}}};const formatDate=e=>`${e.getFullYear()}-${String(e.getMonth()+1).padStart(2,"0")}-${String(e.getDate()).padStart(2,"0")}`,formatMonth=e=>`${e.getFullYear()}-${String(e.getMonth()+1).padStart(2,"0")}-01`;exports.default=async e=>{const{user:t,query:r,ctx:a}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==a||a.step("Fetching get creator performance");const o=t.id,n=new Date,i=(null==r?void 0:r.range)||"30d";let s=[];if("7d"===i){const e=n.getDay(),t=0===e?-6:1-e,r=new Date(n);r.setDate(n.getDate()+t);const a=new Date(r);a.setDate(r.getDate()+6);s=await getCreatorDailyChartData(o,r,a)}else if("30d"===i){const e=new Date(n.getFullYear(),n.getMonth(),1),t=new Date(n.getFullYear(),n.getMonth()+1,0);s=await getCreatorDailyChartData(o,e,t)}else if("90d"===i){const e=new Date(n.getFullYear(),n.getMonth()-2,1),t=new Date(n.getFullYear(),n.getMonth()+1,0);s=await getCreatorDailyChartData(o,e,t)}else{if("all"!==i)throw(0,error_1.createError)({statusCode:400,message:"Invalid range parameter"});{const e=await db_1.models.icoTransaction.findOne({include:[{model:db_1.models.icoTokenOffering,as:"offering",attributes:[],where:{userId:o}}],attributes:[[(0,sequelize_1.fn)("MIN",(0,sequelize_1.literal)("icoTransaction.createdAt")),"minDate"]],raw:!0});let t;if(e&&e.minDate)t=new Date(e.minDate);else{t=new Date;t.setFullYear(t.getFullYear()-1)}const r=new Date(n.getFullYear(),n.getMonth()-11,1);t>r&&(t=r);s=await getCreatorMonthlyChartData(o,t,n)}}null==a||a.success(`Retrieved ${s.length} data points for ${i} period`);return s};