"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Investors for Creator Offerings",description:"Retrieves aggregated investor details (including total amount invested, total tokens purchased, latest transaction date, rejected investment amount, and token info from the ICO offering) for ICO offerings created by the authenticated creator. Supports pagination, sorting, and searching. (Aggregation is done by computing valid transactions (PENDING/RELEASED) and rejected transactions separately.)",operationId:"getCreatorInvestors",tags:["ICO","Creator","Investors"],logModule:"ICO",logTitle:"Get creator investors",requiresAuth:!0,parameters:[{index:0,name:"page",in:"query",required:!1,schema:{type:"number"},description:"Page number"},{index:1,name:"limit",in:"query",required:!1,schema:{type:"number"},description:"Number of items per page"},{index:2,name:"sortField",in:"query",required:!1,schema:{type:"string"},description:"Field to sort by. For associated fields use dot notation (e.g. 'user.firstName'). Defaults to 'lastTransactionDate'."},{index:3,name:"sortDirection",in:"query",required:!1,schema:{type:"string"},description:"Sort direction: asc or desc (default: desc)"},{index:4,name:"search",in:"query",required:!1,schema:{type:"string"},description:"Search query to filter by investor first or last name"}],responses:{200:{description:"Investors retrieved successfully.",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object"}},pagination:{type:"object",properties:{currentPage:{type:"number"},totalPages:{type:"number"},totalItems:{type:"number"},itemsPerPage:{type:"number"}}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{user:t,query:r,ctx:s}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==s||s.step("Fetching creator's offerings");const i=(await db_1.models.icoTokenOffering.findAll({attributes:["id"],where:{userId:t.id},raw:!0})).map(e=>e.id);if(0===i.length)return{items:[],pagination:{currentPage:1,totalPages:1,totalItems:0,itemsPerPage:10}};const a={offeringId:{[sequelize_1.Op.in]:i}};if(r.search){const e=r.search.toLowerCase();a[sequelize_1.Op.and]=[{[sequelize_1.Op.or]:[{"$user.firstName$":{[sequelize_1.Op.like]:`%${e}%`}},{"$user.lastName$":{[sequelize_1.Op.like]:`%${e}%`}}]}]}const o=parseInt(r.page,10)||1,n=parseInt(r.limit,10)||10,c=(o-1)*n,l=r.sortField||"lastTransactionDate",u=r.sortDirection&&"ASC"===r.sortDirection.toUpperCase()?"ASC":"DESC";let d;if(l.includes(".")){const e=l.split(".");d="user"===e[0]?[[{model:db_1.models.user,as:"user"},e[1],u]]:"offering"===e[0]?[[{model:db_1.models.icoTokenOffering,as:"offering"},e[1],u]]:[[l,u]]}else d=[[l,u]];null==s||s.step("Aggregating investor data");const p=await db_1.models.icoTransaction.findAll({attributes:["userId","offeringId",[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN icoTransaction.status IN ('PENDING', 'RELEASED') THEN icoTransaction.amount * icoTransaction.price ELSE 0 END")),"totalCost"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN icoTransaction.status = 'REJECTED' THEN icoTransaction.amount * icoTransaction.price ELSE 0 END")),"rejectedCost"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN icoTransaction.status IN ('PENDING', 'RELEASED') THEN icoTransaction.amount ELSE 0 END")),"totalTokens"],[(0,sequelize_1.fn)("MAX",(0,sequelize_1.col)("icoTransaction.createdAt")),"lastTransactionDate"]],include:[{model:db_1.models.user,as:"user",attributes:["firstName","lastName","avatar"]},{model:db_1.models.icoTokenOffering,as:"offering",attributes:["name","symbol","icon"]}],where:a,group:["userId","offeringId","user.id","offering.id"],order:d,raw:!1}),m=p.length,g=Math.ceil(m/n),f=p.slice(c,c+n);null==s||s.success(`Retrieved ${f.length} investors (page ${o}/${g})`);return{items:f,pagination:{currentPage:o,totalPages:g,totalItems:m,itemsPerPage:n}}};