"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),gateway_1=require("@b/utils/gateway"),utils_1=require("../utils"),console_1=require("@b/utils/console");exports.metadata={summary:"Create a refund",description:"Creates a refund for a completed payment. Can be a full or partial refund.",operationId:"createRefund",tags:["Gateway","Refund"],requestBody:{required:!0,content:{"application/json":{schema:utils_1.createRefundSchema}}},responses:{201:{description:"Refund created successfully",content:{"application/json":{schema:utils_1.refundResponseSchema}}},400:{description:"Invalid request or payment cannot be refunded"},401:{description:"Invalid or missing API key"},404:{description:"Payment not found"}},requiresAuth:!1,logModule:"GATEWAY",logTitle:"Create Refund"};exports.default=async e=>{var t,a,r,n;const{body:s,headers:o,ctx:d}=e;null==d||d.step("Authenticate API key");const u=(null==o?void 0:o["x-api-key"])||(null==o?void 0:o["X-API-Key"]),i=(null===(a=null===(t=null==o?void 0:o["x-forwarded-for"])||void 0===t?void 0:t.split(",")[0])||void 0===a?void 0:a.trim())||(null==o?void 0:o["x-real-ip"])||(null==o?void 0:o["cf-connecting-ip"])||null,{merchant:l,apiKey:c,isTestMode:m,isSecretKey:f}=await(0,gateway_1.authenticateGatewayApi)(u,i);if(!f){null==d||d.fail("Secret key required");throw(0,error_1.createError)({statusCode:403,message:"Secret key required to create refunds"})}(0,gateway_1.checkApiPermission)(c,"refund.create");null==d||d.step("Validate required fields");if(!s.paymentId){null==d||d.fail("Missing paymentId");throw(0,error_1.createError)({statusCode:400,message:"Missing required field: paymentId"})}null==d||d.step("Find payment to refund");const p=await db_1.models.gatewayPayment.findOne({where:{paymentIntentId:s.paymentId,merchantId:l.id}});if(!p){null==d||d.fail("Payment not found");throw(0,error_1.createError)({statusCode:404,message:"Payment not found"})}if(p.testMode!==m){null==d||d.fail("Test mode mismatch");throw(0,error_1.createError)({statusCode:404,message:"Payment not found"})}null==d||d.step("Validate payment can be refunded");if("COMPLETED"!==p.status&&"PARTIALLY_REFUNDED"!==p.status){null==d||d.fail(`Payment status is ${p.status}`);throw(0,error_1.createError)({statusCode:400,message:`Payment with status ${p.status} cannot be refunded`})}null==d||d.step("Calculate refund amount and validate");const y=s.amount?parseFloat(s.amount):p.amount,g=(await db_1.models.gatewayRefund.findAll({where:{paymentId:p.id,status:"COMPLETED"}})).reduce((e,t)=>e+parseFloat(t.amount),0),E=p.amount-g;if(y>E){null==d||d.fail("Refund amount exceeds remaining refundable amount");throw(0,error_1.createError)({statusCode:400,message:`Refund amount ${y} exceeds remaining refundable amount ${E}`})}null==d||d.step("Generate refund ID and calculate fees");const h=(0,gateway_1.generateRefundId)(),w=p.feeAmount/p.amount,I=y*w;let _;null==d||d.step("Process refund in database transaction");try{_=await db_1.sequelize.transaction(async e=>{const t=await db_1.models.gatewayRefund.create({paymentId:p.id,merchantId:l.id,refundId:h,amount:y,currency:p.currency,reason:s.reason||"REQUESTED_BY_CUSTOMER",description:s.description||null,status:"COMPLETED",metadata:s.metadata||null},{transaction:e});if(p.customerId&&!p.testMode){const a=p.allocations||[];if(0===a.length)throw(0,error_1.createError)({statusCode:400,message:"Payment has no allocation data for refund processing"});const r=await(0,gateway_1.processMultiWalletRefund)({userId:p.customerId,merchantUserId:l.userId,merchantId:l.id,paymentCurrency:p.currency,allocations:a,refundAmount:y,totalPaymentAmount:p.amount,feeAmount:I,refundId:h,paymentId:p.paymentIntentId,description:`Refund for payment ${p.paymentIntentId}`,transaction:e});await t.update({transactionId:r.userTransaction.id},{transaction:e})}const a=g+y>=p.amount?"REFUNDED":"PARTIALLY_REFUNDED";await p.update({status:a},{transaction:e});return t})}catch(e){null==d||d.fail(`Refund processing failed: ${e.message}`);if("SequelizeValidationError"===e.name||"SequelizeUniqueConstraintError"===e.name){const t=[];e.errors&&Array.isArray(e.errors)&&e.errors.forEach(e=>{t.push(e.message)});const a=t.length>0?t.join("; "):e.message||"Validation failed";throw(0,error_1.createError)({statusCode:400,message:a})}if(null===(r=e.message)||void 0===r?void 0:r.includes("Insufficient"))throw(0,error_1.createError)({statusCode:400,message:e.message});if(null===(n=e.message)||void 0===n?void 0:n.includes("wallet not found"))throw(0,error_1.createError)({statusCode:400,message:e.message});if(e.statusCode)throw e;console_1.logger.error("GATEWAY_REFUND","Refund processing failed",e);throw(0,error_1.createError)({statusCode:500,message:`Failed to process refund: ${e.message}`})}null==d||d.step("Send refund completion webhook");if(p.webhookUrl)try{await(0,gateway_1.sendWebhook)(l.id,p.id,_.id,"refund.completed",p.webhookUrl,{id:`evt_${h}`,type:"refund.completed",createdAt:(new Date).toISOString(),data:{id:h,paymentId:p.paymentIntentId,merchantOrderId:p.merchantOrderId,amount:y,currency:p.currency,status:"COMPLETED",reason:s.reason||"REQUESTED_BY_CUSTOMER"}},l.webhookSecret)}catch(e){console_1.logger.error("GATEWAY_REFUND","Failed to send refund.completed webhook",e)}null==d||d.success("Refund created successfully");return{id:h,paymentId:p.paymentIntentId,amount:y,currency:p.currency,status:"COMPLETED",reason:s.reason||"REQUESTED_BY_CUSTOMER",description:s.description||null,createdAt:_.createdAt}};