"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),gateway_1=require("@b/utils/gateway"),cache_1=require("@b/utils/cache");exports.metadata={summary:"Register as merchant",description:"Registers the current user as a payment gateway merchant.",operationId:"registerMerchant",tags:["Gateway","Merchant"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{name:{type:"string",description:"Business name",minLength:2,maxLength:191},email:{type:"string",format:"email",description:"Business email"},website:{type:"string",format:"uri",description:"Business website (optional)"},description:{type:"string",description:"Business description (optional)"},phone:{type:"string",description:"Business phone (optional)"},address:{type:"string",description:"Business address (optional)"},city:{type:"string",description:"City (optional)"},state:{type:"string",description:"State/Province (optional)"},country:{type:"string",description:"Country code (optional)"},postalCode:{type:"string",description:"Postal/ZIP code (optional)"}},required:["name","email"]}}}},responses:{201:{description:"Merchant registered successfully"},400:{description:"Invalid request or merchant already exists"}},requiresAuth:!0,logModule:"GATEWAY",logTitle:"Register Merchant Account"};exports.default=async e=>{const{user:t,body:a,ctx:s}=e;null==s||s.step("Validate user authentication");if(!(null==t?void 0:t.id)){null==s||s.fail("Unauthorized - no user ID");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}null==s||s.step("Validate gateway settings and requirements");const r=await(0,gateway_1.getGatewaySettings)();if(!r.gatewayEnabled){null==s||s.fail("Payment gateway is disabled");throw(0,error_1.createError)({statusCode:400,message:"Payment gateway is currently disabled"})}if(r.gatewayRequireKyc){const e=cache_1.CacheManager.getInstance(),a=await e.getSetting("kycStatus");if(!0===a||"true"===a){if(!await db_1.models.kycApplication.findOne({where:{userId:t.id,status:"APPROVED"}})){null==s||s.fail("KYC verification required");throw(0,error_1.createError)({statusCode:400,message:"KYC verification is required to become a merchant. Please complete your KYC verification first."})}}}null==s||s.step("Check for existing merchant account");if(await db_1.models.gatewayMerchant.findOne({where:{userId:t.id}})){null==s||s.fail("User already has a merchant account");throw(0,error_1.createError)({statusCode:400,message:"You already have a merchant account"})}null==s||s.step("Validate required fields");if(!a.name||!a.email){null==s||s.fail("Missing required fields");throw(0,error_1.createError)({statusCode:400,message:"Missing required fields: name, email"})}null==s||s.step("Configure wallet types and currencies");const i=r.gatewayAllowedWalletTypes||{},n=[],o=[];for(const[e,t]of Object.entries(i))if(t&&"object"==typeof t&&t.enabled){n.push(e);const a=t.currencies||[];a.length>0&&o.push(...a.slice(0,3))}const l=n.length>0?n:["FIAT"],c=o.length>0?[...new Set(o)]:["USD"],d=c[0]||"USD";null==s||s.step("Generate API keys and webhook secret");const u=(0,gateway_1.generateApiKey)("pk_live_"),y=(0,gateway_1.generateApiKey)("sk_live_"),p=(0,gateway_1.generateApiKey)("pk_test_"),g=(0,gateway_1.generateApiKey)("sk_test_"),m=(0,gateway_1.generateRandomString)(32),h=r.gatewayAutoApproveVerified&&r.gatewayRequireKyc?"ACTIVE":"PENDING";null==s||s.step("Create merchant account");const w=await db_1.models.gatewayMerchant.create({userId:t.id,name:a.name,email:a.email,website:a.website||null,description:a.description||null,phone:a.phone||null,address:a.address||null,city:a.city||null,state:a.state||null,country:a.country||null,postalCode:a.postalCode||null,apiKey:u,secretKey:y,webhookSecret:m,testMode:!0,allowedCurrencies:c,allowedWalletTypes:l,defaultCurrency:d,feeType:"BOTH",feePercentage:r.gatewayFeePercentage||2.9,feeFixed:r.gatewayFeeFixed||.3,payoutSchedule:r.gatewayPayoutSchedule||"DAILY",payoutThreshold:r.gatewayMinPayoutAmount||100,status:h,verificationStatus:"PENDING",dailyLimit:r.gatewayDailyLimit||1e4,monthlyLimit:r.gatewayMonthlyLimit||1e5,transactionLimit:r.gatewayMaxPaymentAmount||5e3});null==s||s.step("Create API key records");const f=[{prefix:"pk_live_",key:u,type:"PUBLIC",mode:"LIVE"},{prefix:"sk_live_",key:y,type:"SECRET",mode:"LIVE"},{prefix:"pk_test_",key:p,type:"PUBLIC",mode:"TEST"},{prefix:"sk_test_",key:g,type:"SECRET",mode:"TEST"}],_=[];for(const e of f){const t=await db_1.models.gatewayApiKey.create({merchantId:w.id,name:`Default ${e.mode} ${e.type} Key`,keyPrefix:e.prefix,keyHash:(0,gateway_1.hashApiKey)(e.key),lastFourChars:(0,gateway_1.getLastFourChars)(e.key),type:e.type,mode:e.mode,permissions:["*"],status:!0});_.push({id:t.id,name:t.name,type:t.type,mode:t.mode,key:e.key,createdAt:t.createdAt})}null==s||s.success("Merchant account created successfully");return{message:"Merchant account created successfully. Pending approval.",merchant:{id:w.id,name:w.name,slug:w.slug,email:w.email,status:w.status,verificationStatus:w.verificationStatus,testMode:w.testMode,createdAt:w.createdAt},apiKeys:_,webhookSecret:m,note:"Save your API keys and webhook secret securely. Secret keys will not be shown again."}};