"use strict";async function query(e,r=[]){if(!client)throw(0,error_1.createError)({statusCode:503,message:"Ecosystem extension not available"});return client.execute(e,r,{prepare:!0})}async function getOrderbookEntry(e,r,o){if(!client||!scyllaFuturesKeyspace||!toBigIntFloat)throw(0,error_1.createError)({statusCode:503,message:"Ecosystem extension not available"});const t=`\n    SELECT * FROM ${scyllaFuturesKeyspace}.orderbook\n    WHERE symbol = ? AND price = ? AND side = ?;\n  `,s=[e,r,o];try{const e=await client.execute(t,s,{prepare:!0});if(e.rows.length>0){const r=e.rows[0];return toBigIntFloat(r.amount)}console_1.logger.warn("ORDERBOOK",`Orderbook entry not found for params: ${JSON.stringify(s)}`);return null}catch(e){console_1.logger.error("ORDERBOOK","Failed to fetch futures orderbook entry",e);throw(0,error_1.createError)({statusCode:500,message:`Failed to fetch futures orderbook entry: ${e.message}`})}}async function getOrderBook(e){if(!client||!scyllaFuturesKeyspace)throw(0,error_1.createError)({statusCode:503,message:"Ecosystem extension not available"});const r=`\n    SELECT * FROM ${scyllaFuturesKeyspace}.orderbook\n    WHERE symbol = ? AND side = 'ASKS'\n    LIMIT 50;\n  `,o=`\n    SELECT * FROM ${scyllaFuturesKeyspace}.orderbook\n    WHERE symbol = ? AND side = 'BIDS'\n    ORDER BY price DESC\n    LIMIT 50;\n  `,[t,s]=await Promise.all([client.execute(r,[e],{prepare:!0}),client.execute(o,[e],{prepare:!0})]);return{asks:t.rows.map(e=>[e.price,e.amount]),bids:s.rows.map(e=>[e.price,e.amount])}}async function fetchOrderBooks(){if(!client||!scyllaFuturesKeyspace)throw(0,error_1.createError)({statusCode:503,message:"Ecosystem extension not available"});const e=`\n    SELECT * FROM ${scyllaFuturesKeyspace}.orderbook;\n  `;try{return(await client.execute(e)).rows.map(e=>({symbol:e.symbol,price:e.price,amount:e.amount,side:e.side}))}catch(e){console_1.logger.error("ORDERBOOK","Failed to fetch futures order books",e);return null}}async function updateOrderBookInDB(e,r,o,t){if(!client||!scyllaFuturesKeyspace)throw(0,error_1.createError)({statusCode:503,message:"Ecosystem extension not available"});let s,a;if(o>0){s=`\n      INSERT INTO ${scyllaFuturesKeyspace}.orderbook (symbol, price, amount, side)\n      VALUES (?, ?, ?, ?);\n    `;a=[e,r,o,t.toUpperCase()]}else{s=`\n      DELETE FROM ${scyllaFuturesKeyspace}.orderbook\n      WHERE symbol = ? AND price = ? AND side = ?;\n    `;a=[e,r,t.toUpperCase()]}try{await client.execute(s,a,{prepare:!0})}catch(e){console_1.logger.error("ORDERBOOK","Failed to update futures order book",e)}}async function fetchExistingAmounts(e){if(!(client&&scyllaFuturesKeyspace&&removeTolerance&&toBigIntFloat))throw(0,error_1.createError)({statusCode:503,message:"Ecosystem extension not available"});try{const r=await client.execute(`SELECT price, side, amount FROM ${scyllaFuturesKeyspace}.orderbook_by_symbol WHERE symbol = ?;`,[e]),o={bids:{},asks:{}};r.rows.forEach(e=>{const r="BIDS"===e.side?"bids":"asks",t=removeTolerance(toBigIntFloat(e.price)).toString();o[r][t]=removeTolerance(toBigIntFloat(e.amount))});return o}catch(r){console_1.logger.error("FUTURES",`Failed to fetch existing amounts for ${e}`,r);throw(0,error_1.createError)({statusCode:500,message:`Failed to fetch existing amounts for ${e}`})}}async function updateSingleOrderBook(e,r){if(!(client&&scyllaFuturesKeyspace&&removeTolerance&&toBigIntFloat&&fromBigInt))throw(0,error_1.createError)({statusCode:503,message:"Ecosystem extension not available"});try{const o=await client.execute(`SELECT price, side, amount FROM ${scyllaFuturesKeyspace}.orderbook_by_symbol WHERE symbol = ?;`,[e.symbol]),t={bids:{},asks:{}};o.rows.forEach(e=>{const r="BIDS"===e.side?"bids":"asks";t[r][removeTolerance(toBigIntFloat(e.price)).toString()]=removeTolerance(toBigIntFloat(e.amount))});const s="BUY"===e.side?"bids":"asks",a=removeTolerance(BigInt(e.price)),n=t[s][a.toString()]||BigInt(0);let c=BigInt(0);"add"===r?c=n+removeTolerance(BigInt(e.amount)):"subtract"===r&&(c=n-removeTolerance(BigInt(e.amount)));if(c>BigInt(0)){await client.execute(`INSERT INTO ${scyllaFuturesKeyspace}.orderbook (symbol, price, side, amount) VALUES (?, ?, ?, ?)`,[e.symbol,fromBigInt(a),"BUY"===e.side?"BIDS":"ASKS",fromBigInt(c)]);t[s][a.toString()]=c}else{await client.execute(`DELETE FROM ${scyllaFuturesKeyspace}.orderbook WHERE symbol = ? AND price = ? AND side = ?`,[e.symbol,fromBigInt(a),"BUY"===e.side?"BIDS":"ASKS"]);delete t[s][a.toString()]}return t}catch(e){console_1.logger.error("FUTURES","Failed to update order book in database",e);throw(0,error_1.createError)({statusCode:500,message:"Failed to update order book in database"})}}function generateOrderBookUpdateQueries(e){if(!scyllaFuturesKeyspace||!fromBigInt||!removeTolerance)throw(0,error_1.createError)({statusCode:503,message:"Ecosystem extension not available"});const r=[];for(const[o,t]of Object.entries(e))for(const[e,s]of Object.entries(t))if(0!==Object.keys(s).length)for(const[t,a]of Object.entries(s))a>BigInt(0)?r.push({query:`UPDATE ${scyllaFuturesKeyspace}.orderbook SET amount = ? WHERE symbol = ? AND price = ? AND side = ?`,params:[fromBigInt(removeTolerance(BigInt(a))),o,fromBigInt(removeTolerance(BigInt(t))),e.toUpperCase()]}):r.push({query:`DELETE FROM ${scyllaFuturesKeyspace}.orderbook WHERE symbol = ? AND price = ? AND side = ?`,params:[o,fromBigInt(removeTolerance(BigInt(t))),e.toUpperCase()]});else r.push({query:`DELETE FROM ${scyllaFuturesKeyspace}.orderbook WHERE symbol = ? AND side = ?`,params:[o,e.toUpperCase()]});return r}Object.defineProperty(exports,"__esModule",{value:!0});exports.query=query;exports.getOrderbookEntry=getOrderbookEntry;exports.getOrderBook=getOrderBook;exports.fetchOrderBooks=fetchOrderBooks;exports.updateOrderBookInDB=updateOrderBookInDB;exports.fetchExistingAmounts=fetchExistingAmounts;exports.updateSingleOrderBook=updateSingleOrderBook;exports.generateOrderBookUpdateQueries=generateOrderBookUpdateQueries;const error_1=require("@b/utils/error");let fromBigInt,removeTolerance,toBigIntFloat,client,scyllaFuturesKeyspace,OrderBookDatas;try{const e=require("@b/api/(ext)/ecosystem/utils/blockchain");fromBigInt=e.fromBigInt;removeTolerance=e.removeTolerance;toBigIntFloat=e.toBigIntFloat;const r=require("@b/api/(ext)/ecosystem/utils/scylla/client");client=r.default;scyllaFuturesKeyspace=r.scyllaFuturesKeyspace;OrderBookDatas=require("@b/api/(ext)/ecosystem/utils/scylla/queries").OrderBookDatas}catch(e){}const console_1=require("@b/utils/console");