"use strict";function uuidToString(e){return(0,uuid_1.stringify)(e.buffer)}async function query(e,r=[]){if(!client)throw(0,error_1.createError)({statusCode:503,message:"Ecosystem extension not available"});return client.execute(e,r,{prepare:!0})}async function getOrdersByUserId(e){if(!client||!scyllaFuturesKeyspace)throw(0,error_1.createError)({statusCode:503,message:"Ecosystem extension not available"});const r=`\n    SELECT * FROM ${scyllaFuturesKeyspace}.orders\n    WHERE "userId" = ?\n    ORDER BY "createdAt" DESC;\n  `,t=[e];try{return(await client.execute(r,t,{prepare:!0})).rows.map(mapRowToOrder)}catch(e){console_1.logger.error("FUTURES",`Failed to fetch futures orders by userId: ${e.message}`);throw(0,error_1.createError)({statusCode:500,message:`Failed to fetch futures orders by userId: ${e.message}`})}}function mapRowToOrder(e){return{id:e.id,userId:e.userId,symbol:e.symbol,type:e.type,side:e.side,price:e.price,amount:e.amount,filled:e.filled,remaining:e.remaining,timeInForce:e.timeInForce,cost:e.cost,fee:e.fee,feeCurrency:e.feeCurrency,average:e.average,trades:e.trades,status:e.status,createdAt:e.createdAt,updatedAt:e.updatedAt,leverage:e.leverage,stopLossPrice:e.stopLossPrice,takeProfitPrice:e.takeProfitPrice}}function getOrderByUuid(e,r,t){if(!client||!scyllaFuturesKeyspace)throw(0,error_1.createError)({statusCode:503,message:"Ecosystem extension not available"});const s=`\n    SELECT * FROM ${scyllaFuturesKeyspace}.orders\n    WHERE "userId" = ? AND id = ? AND "createdAt" = ?;\n  `,a=[e,r,t];return client.execute(s,a,{prepare:!0}).then(e=>e.rows[0]).then(mapRowToOrder)}async function cancelOrderByUuid(e,r,t,s,a,o,n){if(!client||!scyllaFuturesKeyspace||!fromBigInt)throw(0,error_1.createError)({statusCode:503,message:"Ecosystem extension not available"});const c=fromBigInt(a),i="BUY"===o?"BIDS":"ASKS",l=await(0,orderbook_1.getOrderbookEntry)(s,c,i);let u="",d=[];if(l){const e=l-n;if(e<=BigInt(0)){u=`DELETE FROM ${scyllaFuturesKeyspace}.orderbook WHERE symbol = ? AND price = ? AND side = ?`;d=[s,c.toString(),i]}else{u=`UPDATE ${scyllaFuturesKeyspace}.orderbook SET amount = ? WHERE symbol = ? AND price = ? AND side = ?`;d=[fromBigInt(e).toString(),s,c.toString(),i]}}else console_1.logger.warn("FUTURES",`No orderbook entry found for symbol: ${s}, price: ${c}, side: ${i}`);const g=`DELETE FROM ${scyllaFuturesKeyspace}.orders WHERE "userId" = ? AND id = ? AND "createdAt" = ?`,y=[e,r,t],p=u?[{query:u,params:d},{query:g,params:y}]:[{query:g,params:y}];try{await client.batch(p,{prepare:!0})}catch(e){console_1.logger.error("FUTURES",`Failed to cancel futures order and update orderbook: ${e.message}`);throw(0,error_1.createError)({statusCode:500,message:`Failed to cancel futures order and update orderbook: ${e.message}`})}}function applyLeverage(e,r){return e*BigInt(Math.max(1,Math.floor(r)))}async function createOrder({userId:e,symbol:r,amount:t,price:s,cost:a,type:o,side:n,fee:c,feeCurrency:i,leverage:l,stopLossPrice:u,takeProfitPrice:d}){if(!client||!scyllaFuturesKeyspace||!removeTolerance)throw(0,error_1.createError)({statusCode:503,message:"Ecosystem extension not available"});const g=new Date,y=applyLeverage(t,l),p=`\n    INSERT INTO ${scyllaFuturesKeyspace}.orders (\n      id, "userId", symbol, type, "timeInForce", side, price, average,\n      amount, filled, remaining, cost, leverage, fee, "feeCurrency", status,\n      "stopLossPrice", "takeProfitPrice", "createdAt", "updatedAt"\n    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);\n  `,m=removeTolerance(s),f=removeTolerance(y),E=removeTolerance(a),I=removeTolerance(c),F=u?removeTolerance(u):void 0,B=d?removeTolerance(d):void 0,A=(0,passwords_1.makeUuid)(),O=[A,e,r,o,"GTC",n,m.toString(),"0",f.toString(),"0",f.toString(),E.toString(),l.toString(),I.toString(),i,"OPEN",F?F.toString():null,B?B.toString():null,g,g];try{await client.execute(p,O,{prepare:!0});const t={id:A,userId:e,symbol:r,type:o,timeInForce:"GTC",side:n,price:m,amount:f,filled:BigInt(0),remaining:f,cost:E,fee:I,feeCurrency:i,average:BigInt(0),trades:"",status:"OPEN",createdAt:g,updatedAt:g,leverage:l,stopLossPrice:F,takeProfitPrice:B};(await matchingEngine_1.FuturesMatchingEngine.getInstance()).addToQueue(t);return t}catch(e){console_1.logger.error("FUTURES",`Failed to create futures order: ${e.message}`);throw(0,error_1.createError)({statusCode:500,message:`Failed to create futures order: ${e.message}`})}}async function getAllOpenOrders(){if(!client||!scyllaFuturesKeyspace)throw(0,error_1.createError)({statusCode:503,message:"Ecosystem extension not available"});const e=`\n    SELECT * FROM ${scyllaFuturesKeyspace}.open_order\n    WHERE status = 'OPEN' ALLOW FILTERING;\n  `;try{return(await client.execute(e,[],{prepare:!0})).rows}catch(e){console_1.logger.error("FUTURES",`Failed to fetch all open futures orders: ${e.message}`);throw(0,error_1.createError)({statusCode:500,message:`Failed to fetch all open futures orders: ${e.message}`})}}function generateOrderUpdateQueries(e){if(!scyllaFuturesKeyspace||!removeTolerance)throw(0,error_1.createError)({statusCode:503,message:"Ecosystem extension not available"});return e.map(e=>({query:`\n        UPDATE ${scyllaFuturesKeyspace}.orders\n        SET filled = ?, remaining = ?, status = ?, "updatedAt" = ?, trades = ?\n        WHERE "userId" = ? AND "createdAt" = ? AND id = ?;\n      `,params:[removeTolerance(e.filled).toString(),removeTolerance(e.remaining).toString(),e.status,new Date,JSON.stringify(e.trades),e.userId,e.createdAt,e.id]}))}async function deleteAllMarketData(e){if(!client||!scyllaFuturesKeyspace)throw(0,error_1.createError)({statusCode:503,message:"Ecosystem extension not available"});const r=await client.execute(`\n      SELECT "userId", "createdAt", id\n      FROM ${scyllaFuturesKeyspace}.orders_by_symbol\n      WHERE symbol = ?\n      ALLOW FILTERING;\n    `,[e],{prepare:!0});for(const e of r.rows)await cancelAndRefundOrder(e.userId,e.id,e.createdAt);const t=r.rows.map(e=>({query:`\n      DELETE FROM ${scyllaFuturesKeyspace}.orders\n      WHERE "userId" = ? AND "createdAt" = ? AND id = ?;\n    `,params:[e.userId,e.createdAt,e.id]})),s=(await client.execute(`\n      SELECT interval, "createdAt"\n      FROM ${scyllaFuturesKeyspace}.candles\n      WHERE symbol = ?;\n    `,[e],{prepare:!0})).rows.map(r=>({query:`\n      DELETE FROM ${scyllaFuturesKeyspace}.candles\n      WHERE symbol = ? AND interval = ? AND "createdAt" = ?;\n    `,params:[e,r.interval,r.createdAt]})),a=["ASKS","BIDS"],o=[];for(const r of a){const t=(await client.execute(`\n        SELECT price\n        FROM ${scyllaFuturesKeyspace}.orderbook\n        WHERE symbol = ? AND side = ?;\n      `,[e,r],{prepare:!0})).rows.map(t=>({query:`\n        DELETE FROM ${scyllaFuturesKeyspace}.orderbook\n        WHERE symbol = ? AND side = ? AND price = ?;\n      `,params:[e,r,t.price]}));o.push(...t)}const n=[...t,...s,...o];if(0!==n.length)try{await client.batch(n,{prepare:!0})}catch(e){console_1.logger.error("FUTURES",`Failed to delete all futures market data: ${e.message}`)}}async function cancelAndRefundOrder(e,r,t){const s=await getOrderByUuid(e,r,t);if(!s){console_1.logger.warn("FUTURES",`Order not found for UUID: ${r}`);return}if("OPEN"!==s.status||BigInt(s.remaining)===BigInt(0))return;if(!(fromBigIntMultiply&&fromBigInt&&getWalletByUserIdAndCurrency&&updateWalletBalance)){console_1.logger.warn("FUTURES","Ecosystem extension not available for wallet operations");return}const a="BUY"===s.side?fromBigIntMultiply(BigInt(s.remaining)+BigInt(s.fee),BigInt(s.price)):fromBigInt(BigInt(s.remaining)+BigInt(s.fee)),o="BUY"===s.side?s.symbol.split("/")[1]:s.symbol.split("/")[0],n=await getWalletByUserIdAndCurrency(e,o);n?await updateWalletBalance(n,a,"add"):console_1.logger.warn("FUTURES",`${o} wallet not found for user ID: ${e}`)}async function getOrders(e,r,t){if(!client||!scyllaFuturesKeyspace||!fromBigInt)throw(0,error_1.createError)({statusCode:503,message:"Ecosystem extension not available"});let s=`\n    SELECT * FROM ${scyllaFuturesKeyspace}.orders\n    WHERE "userId" = ?\n  `;const a=[e];if(r){s+=" AND symbol = ?";a.push(r)}t&&(s+=" AND status = 'OPEN'");s+=' ORDER BY "createdAt" DESC ALLOW FILTERING';try{return(await client.execute(s,a,{prepare:!0})).rows.map(mapRowToOrder).map(e=>({...e,amount:fromBigInt(e.amount),price:fromBigInt(e.price),cost:fromBigInt(e.cost),fee:fromBigInt(e.fee),filled:fromBigInt(e.filled),remaining:fromBigInt(e.remaining),average:e.average?fromBigInt(e.average):0,stopLossPrice:e.stopLossPrice?fromBigInt(e.stopLossPrice):void 0,takeProfitPrice:e.takeProfitPrice?fromBigInt(e.takeProfitPrice):void 0}))}catch(e){console_1.logger.error("FUTURES",`Failed to fetch futures orders: ${e.message}`);throw(0,error_1.createError)({statusCode:500,message:`Failed to fetch futures orders: ${e.message}`})}}async function cancelAllOrdersByUserId(e){try{const r=await getOrders(e,void 0,!0);if(0===r.length)return{cancelledCount:0};let t=0;for(const e of r)try{await cancelOrderByUuid(e.userId,e.id,e.createdAt.toISOString(),e.symbol,BigInt(Math.floor(1e8*e.price)),e.side,BigInt(Math.floor(1e8*e.remaining)));t++}catch(r){console_1.logger.error("FUTURES",`Failed to cancel order ${e.id}: ${r}`)}return{cancelledCount:t}}catch(r){console_1.logger.error("FUTURES",`Failed to cancel all orders for user ${e}: ${r}`);throw(0,error_1.createError)({statusCode:500,message:`Failed to cancel all orders: ${r.message}`})}}Object.defineProperty(exports,"__esModule",{value:!0});exports.uuidToString=uuidToString;exports.query=query;exports.getOrdersByUserId=getOrdersByUserId;exports.getOrderByUuid=getOrderByUuid;exports.cancelOrderByUuid=cancelOrderByUuid;exports.createOrder=createOrder;exports.getAllOpenOrders=getAllOpenOrders;exports.generateOrderUpdateQueries=generateOrderUpdateQueries;exports.deleteAllMarketData=deleteAllMarketData;exports.getOrders=getOrders;exports.cancelAllOrdersByUserId=cancelAllOrdersByUserId;const error_1=require("@b/utils/error");let fromBigInt,fromBigIntMultiply,removeTolerance,client,scyllaFuturesKeyspace,getWalletByUserIdAndCurrency,updateWalletBalance;try{const e=require("@b/api/(ext)/ecosystem/utils/blockchain");fromBigInt=e.fromBigInt;fromBigIntMultiply=e.fromBigIntMultiply;removeTolerance=e.removeTolerance;const r=require("@b/api/(ext)/ecosystem/utils/scylla/client");client=r.default;scyllaFuturesKeyspace=r.scyllaFuturesKeyspace;const t=require("@b/api/(ext)/ecosystem/utils/wallet");getWalletByUserIdAndCurrency=t.getWalletByUserIdAndCurrency;updateWalletBalance=t.updateWalletBalance}catch(e){}const passwords_1=require("@b/utils/passwords"),console_1=require("@b/utils/console"),matchingEngine_1=require("../matchingEngine"),orderbook_1=require("./orderbook"),uuid_1=require("uuid");