"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.FuturesMatchingEngine=void 0;let client,scyllaFuturesKeyspace,fromBigInt,removeTolerance,toBigIntFloat,normalizeTimeToInterval,Candle;try{const e=require("@b/api/(ext)/ecosystem/utils/scylla/client");client=e.default;scyllaFuturesKeyspace=e.scyllaFuturesKeyspace;const t=require("@b/api/(ext)/ecosystem/utils/blockchain");fromBigInt=t.fromBigInt;removeTolerance=t.removeTolerance;toBigIntFloat=t.toBigIntFloat;const r=require("@b/api/(ext)/ecosystem/utils/ws");normalizeTimeToInterval=r.normalizeTimeToInterval;Candle=require("@b/api/(ext)/ecosystem/utils/scylla/queries").Candle}catch(e){}const orderbook_1=require("./orderbook"),ws_1=require("./ws"),markets_1=require("./markets"),console_1=require("@b/utils/console"),candles_1=require("./candles"),matchmaking_1=require("./matchmaking"),order_1=require("./queries/order"),candle_1=require("./queries/candle"),orderbook_2=require("./queries/orderbook"),positions_1=require("./queries/positions"),liquidation_1=require("./liquidation"),position_1=require("./position");class FuturesMatchingEngine{constructor(){this.orderQueue={};this.marketsBySymbol={};this.lockedOrders=new Set;this.lastCandle={};this.yesterdayCandle={}}static getInstance(){this.instancePromise||(this.instancePromise=(async()=>{const e=new FuturesMatchingEngine;await e.init();return e})());return this.instancePromise}async init(){if(client&&scyllaFuturesKeyspace){await this.initializeMarkets();await this.initializeOrders();await this.initializeLastCandles();await this.initializeYesterdayCandles();await this.initializePositions()}else console_1.logger.warn("FUTURES","Ecosystem extension not available, futures matching engine disabled")}async initializeMarkets(){(await(0,markets_1.getFuturesMarkets)()).forEach(e=>{const t=`${e.currency}/${e.pair}`;e.symbol=t;this.marketsBySymbol[t]=e;this.orderQueue[t]=[]})}async initializeOrders(){try{(await(0,order_1.getAllOpenOrders)()).forEach(e=>{var t,r,o,i,s,a,n,l,c;const d=new Date(e.createdAt),u=new Date(e.updatedAt);if(isNaN(d.getTime())||isNaN(u.getTime())){console_1.logger.error("FUTURES","Invalid date in order",new Error("Invalid date in order"));return}if(!(null===(t=e.userId)||void 0===t?void 0:t.buffer)||!(null===(r=e.id)||void 0===r?void 0:r.buffer)){console_1.logger.error("FUTURES","Invalid Uuid in order",new Error("Invalid Uuid in order"));return}const m={...e,userId:(0,order_1.uuidToString)(e.userId),id:(0,order_1.uuidToString)(e.id),amount:BigInt(null!==(o=e.amount)&&void 0!==o?o:0),price:BigInt(null!==(i=e.price)&&void 0!==i?i:0),cost:BigInt(null!==(s=e.cost)&&void 0!==s?s:0),fee:BigInt(null!==(a=e.fee)&&void 0!==a?a:0),remaining:BigInt(null!==(n=e.remaining)&&void 0!==n?n:0),filled:BigInt(null!==(l=e.filled)&&void 0!==l?l:0),createdAt:d,updatedAt:u,leverage:BigInt(null!==(c=e.leverage)&&void 0!==c?c:0),stopLossPrice:e.stopLossPrice?BigInt(e.stopLossPrice):null,takeProfitPrice:e.takeProfitPrice?BigInt(e.takeProfitPrice):null};this.orderQueue[m.symbol]||(this.orderQueue[m.symbol]=[]);this.orderQueue[m.symbol].push(m)});await this.processQueue()}catch(e){console_1.logger.error("FUTURES","Failed to populate order queue with open orders",e)}}async initializeLastCandles(){try{(await(0,candle_1.getLastCandles)()).forEach(e=>{this.lastCandle[e.symbol]||(this.lastCandle[e.symbol]={});this.lastCandle[e.symbol][e.interval]=e})}catch(e){console_1.logger.error("FUTURES","Failed to initialize last candles",e)}}async initializeYesterdayCandles(){try{const e=await(0,candle_1.getYesterdayCandles)();Object.keys(e).forEach(t=>{const r=e[t];r.length>0&&(this.yesterdayCandle[t]=r[0])})}catch(e){console_1.logger.error("FUTURES","Failed to initialize yesterday's candles",e)}}async initializePositions(){if(toBigIntFloat&&fromBigInt)try{const e=await(0,positions_1.getAllOpenPositions)(),t=[...new Set(e.map(e=>e.userId))];await Promise.all(t.map(async t=>{const r=e.filter(e=>e.userId===t);await Promise.all(r.map(async e=>{var t;const r=null===(t=this.lastCandle[e.symbol])||void 0===t?void 0:t["1m"];if(r){const t=toBigIntFloat(r.close),o=(0,position_1.calculateUnrealizedPnl)(e.entryPrice,e.amount,t,e.side);await(0,positions_1.updatePositionInDB)(e.userId,e.id,e.entryPrice,e.amount,o,e.stopLossPrice,e.takeProfitPrice);await(0,liquidation_1.checkForLiquidation)(e,Number(fromBigInt(t)))}}))}))}catch(e){console_1.logger.error("FUTURES","Failed to initialize positions",e)}else console_1.logger.warn("FUTURES","Ecosystem extension not available for position initialization")}async processQueue(){if(!client||!removeTolerance||!toBigIntFloat){console_1.logger.warn("FUTURES","Ecosystem extension not available for queue processing");return}const e=[],t={},r=await(0,orderbook_2.fetchOrderBooks)(),o={};null==r||r.forEach(e=>{o[e.symbol]||(o[e.symbol]={bids:{},asks:{}});o[e.symbol][e.side.toLowerCase()][removeTolerance(toBigIntFloat(Number(e.price))).toString()]=removeTolerance(toBigIntFloat(Number(e.amount)))});const i=[];for(const r in this.orderQueue){const s=this.orderQueue[r];if(0===s.length)continue;const a=(async()=>{const{matchedOrders:i,bookUpdates:a}=await(0,matchmaking_1.matchAndCalculateOrders)(s,o[r]||{bids:{},asks:{}});if(0!==i.length){e.push(...i);t[r]=a}})();i.push(a)}await Promise.all(i);if(0===e.length)return;await this.performUpdates(e,t);const s={};for(const e in t)s[e]=(0,orderbook_1.applyUpdatesToOrderBook)(o[e],t[e]);const a=[];for(const e in this.orderQueue){const t=(async()=>{this.orderQueue[e]=this.orderQueue[e].filter(e=>"OPEN"===e.status)})();a.push(t)}await Promise.all(a);this.broadcastUpdates(e,s)}async performUpdates(e,t){if(!this.lockOrders(e)){console_1.logger.warn("FUTURES","Couldn't obtain a lock on all orders, skipping this batch.");return}const r=[];r.push(...(0,order_1.generateOrderUpdateQueries)(e));const o=(0,candles_1.getLatestOrdersForCandles)(e);for(const e of o){const t=await this.updateLastCandles(e);r.push(...t)}const i=(0,orderbook_2.generateOrderBookUpdateQueries)(t);r.push(...i);if(r.length>0)try{await client.batch(r,{prepare:!0})}catch(e){console_1.logger.error("FUTURES","Failed to batch update",e)}else console_1.logger.warn("FUTURES","No queries to batch update.");const s=e.map(async e=>{const t=await(0,positions_1.getPositions)(e.userId,e.symbol,"OPEN");if(t.length>0){fromBigInt&&await Promise.all(t.map(t=>(0,liquidation_1.checkForLiquidation)(t,fromBigInt(e.price))));await Promise.all(t.map(e=>(0,ws_1.handlePositionBroadcast)(e)))}});await Promise.all(s);this.unlockOrders(e)}async addToQueue(e){if(!(0,matchmaking_1.validateOrder)(e))return;if(!e.createdAt||isNaN(new Date(e.createdAt).getTime())||!e.updatedAt||isNaN(new Date(e.updatedAt).getTime())){console_1.logger.error("FUTURES","Invalid date in order",new Error("Invalid date in order"));return}this.orderQueue[e.symbol]||(this.orderQueue[e.symbol]=[]);this.orderQueue[e.symbol].push(e);const t=await(0,orderbook_2.updateSingleOrderBook)(e,"add");(0,ws_1.handleOrderBookBroadcast)(e.symbol,t);await this.processQueue()}async updateLastCandles(e){if(!(toBigIntFloat&&fromBigInt&&scyllaFuturesKeyspace&&normalizeTimeToInterval)){console_1.logger.warn("FUTURES","Ecosystem extension not available for candle updates");return[]}let t,r=BigInt(0);try{t=JSON.parse(e.trades)}catch(e){console_1.logger.error("FUTURES","Failed to parse trades",e);return[]}if(t&&t.length>0&&void 0!==t[t.length-1].price)r=toBigIntFloat?toBigIntFloat(t[t.length-1].price):BigInt(0);else{if(void 0===e.price){console_1.logger.error("FUTURES","Neither trade prices nor order price are available",new Error("Neither trade prices nor order price are available"));return[]}r=e.price}const o=[];this.lastCandle[e.symbol]||(this.lastCandle[e.symbol]={});for(const t of candles_1.intervals){const i=await this.generateCandleQueries(e,t,r);i&&o.push(i)}return o}async generateCandleQueries(e,t,r){var o;let i=null===(o=this.lastCandle[e.symbol])||void 0===o?void 0:o[t];const s=normalizeTimeToInterval((new Date).getTime(),t),a=i?normalizeTimeToInterval(new Date(i.createdAt).getTime(),t):null;if(!i||s!==a){let o;if(i)o=i.close;else{const i=await(0,candle_1.getLatestCandleForSymbol)(e.symbol,t);if(i){o=i.close;this.lastCandle[e.symbol]||(this.lastCandle[e.symbol]={});this.lastCandle[e.symbol][t]=i}else o=fromBigInt?fromBigInt(r):0}if(!o&&0!==o)return null;const s=fromBigInt?fromBigInt(r):0,a=new Date(normalizeTimeToInterval((new Date).getTime(),t)),n={symbol:e.symbol,interval:t,open:o,high:Math.max(o,s),low:Math.min(o,s),close:s,volume:fromBigInt?fromBigInt(e.amount):0,createdAt:a,updatedAt:new Date};this.lastCandle[e.symbol]||(this.lastCandle[e.symbol]={});this.lastCandle[e.symbol][t]=n;return{query:`INSERT INTO ${scyllaFuturesKeyspace}.candles (symbol, interval, "createdAt", "updatedAt", open, high, low, close, volume) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)`,params:[e.symbol,t,n.createdAt,n.updatedAt,o,n.high,n.low,n.close,n.volume]}}{let o=`UPDATE ${scyllaFuturesKeyspace}.candles SET "updatedAt" = ?, close = ?`;const s=new Date,a=fromBigInt?fromBigInt(r):0,n=[s,a],l=i.volume+(fromBigInt?fromBigInt(e.amount):0);o+=", volume = ?";n.push(l);if(a>i.high){o+=", high = ?";n.push(a);i.high=a}else if(a<i.low){o+=", low = ?";n.push(a);i.low=a}i.close=a;i.volume=l;i.updatedAt=s;this.lastCandle[e.symbol][t]=i;o+=' WHERE symbol = ? AND interval = ? AND "createdAt" = ?';n.push(e.symbol,t,i.createdAt);return{query:o,params:n}}}async broadcastUpdates(e,t){const r=[];r.push(...this.createOrdersBroadcastPromise(e));for(const e in this.orderQueue)if(t[e]){r.push(this.createOrderBookUpdatePromise(e,t[e]));r.push(...this.createCandleBroadcastPromises(e))}await Promise.all(r)}createOrderBookUpdatePromise(e,t){return(0,ws_1.handleOrderBookBroadcast)(e,t)}createCandleBroadcastPromises(e){const t=[];for(const r in this.lastCandle[e])t.push((0,ws_1.handleCandleBroadcast)(e,r,this.lastCandle[e][r]));t.push((0,ws_1.handleTickerBroadcast)(e,this.getTicker(e)),(0,ws_1.handleTickersBroadcast)(this.getTickers()));return t}createOrdersBroadcastPromise(e){return e.map(e=>(0,ws_1.handleOrderBroadcast)(e))}lockOrders(e){for(const t of e)if(this.lockedOrders.has(t.id))return!1;for(const t of e)this.lockedOrders.add(t.id);return!0}unlockOrders(e){for(const t of e)this.lockedOrders.delete(t.id)}async handleOrderCancellation(e,t){this.orderQueue[t]=this.orderQueue[t].filter(t=>t.id!==e);const r=await(0,orderbook_2.fetchExistingAmounts)(t);(0,ws_1.handleOrderBookBroadcast)(t,r);await this.processQueue()}getTickers(){const e={};for(const t in this.marketsBySymbol)e[t]=this.getTicker(t);return e}getTicker(e){var t;const r=null===(t=this.lastCandle[e])||void 0===t?void 0:t["1d"],o=this.yesterdayCandle[e];if(!r)return{symbol:e,last:0,baseVolume:0,quoteVolume:0,change:0,percentage:0,high:0,low:0};const i=r.close,s=r.volume,a=i*s;let n=0,l=0;if(o){const e=o.close,t=r.close;n=t-e;l=(t-e)/e*100}return{symbol:e,last:i,baseVolume:s,quoteVolume:a,percentage:l,change:n,high:r.high,low:r.low}}}exports.FuturesMatchingEngine=FuturesMatchingEngine;FuturesMatchingEngine.instancePromise=null;