"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),utils_1=require("./utils"),error_1=require("@b/utils/error"),order_1=require("@b/api/(ext)/futures/utils/queries/order");exports.metadata={summary:"List Futures Orders",operationId:"listFuturesOrders",tags:["Futures","Orders"],logModule:"FUTURES",logTitle:"List futures orders",description:"Retrieves a list of futures orders for the authenticated user.",parameters:[{name:"currency",in:"query",description:"Currency of the orders to retrieve.",schema:{type:"string"}},{name:"pair",in:"query",description:"Pair of the orders to retrieve.",schema:{type:"string"}},{name:"type",in:"query",description:"Type of order to retrieve.",schema:{type:"string"}}],responses:{200:{description:"A list of futures orders",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:utils_1.baseOrderSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Order"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{var r,t,s,i;const{user:o,query:u,ctx:a}=e;null===(r=null==a?void 0:a.step)||void 0===r||r.call(a,"Validating user authentication");if(!(null==o?void 0:o.id)){null===(t=null==a?void 0:a.fail)||void 0===t||t.call(a,"User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}const{currency:n,pair:d,type:l}=u,c=n&&d?`${n}/${d}`:void 0,p="OPEN"===l;null===(s=null==a?void 0:a.step)||void 0===s||s.call(a,`Fetching futures orders${c?` for ${c}`:""}${l?` (${l})`:""}`);const y=await(0,order_1.getOrders)(o.id,c,p);null===(i=null==a?void 0:a.success)||void 0===i||i.call(a,`Retrieved ${y.length} futures orders`);return y};