"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Forex Investment Plans",description:"Retrieves a list of forex investment plans filtered and sorted based on query parameters. Parameters include activeTab, search, minProfit, maxInvestment, and sortBy.",operationId:"getForexPlans",tags:["Forex","Plan"],requiresAuth:!0,logModule:"FOREX",logTitle:"Get Forex Plans",parameters:[{name:"activeTab",in:"query",description:'If set to "trending", only trending plans are returned.',required:!1,schema:{type:"string",enum:["all","trending"]}},{name:"search",in:"query",description:"Search term to filter plans by title or description.",required:!1,schema:{type:"string"}},{name:"minProfit",in:"query",description:"Minimum profit value (number) that a plan must have.",required:!1,schema:{type:"number"}},{name:"maxInvestment",in:"query",description:'Maximum investment allowed. Plans with "maxAmount" (defaulting to 100000 if missing) must be less than or equal to this value.',required:!1,schema:{type:"number"}},{name:"sortBy",in:"query",description:'Sort the plans by "popularity" (invested descending), "profit" (profitPercentage descending) or "minInvestment" (minAmount ascending).',required:!1,schema:{type:"string",enum:["popularity","profit","minInvestment"]}}],responses:{200:{description:"Forex investment plans retrieved successfully.",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string"},name:{type:"string"},title:{type:"string"},description:{type:"string"},image:{type:"string"},currency:{type:"string"},walletType:{type:"string"},minProfit:{type:"number"},maxProfit:{type:"number"},minAmount:{type:"number"},maxAmount:{type:"number"},invested:{type:"number"},profitPercentage:{type:"number"},trending:{type:"boolean"},createdAt:{type:"string",format:"date-time"},updatedAt:{type:"string",format:"date-time"}}}}}}},401:{description:"Unauthorized."},500:{description:"Internal Server Error."}}};exports.default=async e=>{const{user:t,query:r,ctx:n}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{activeTab:i="all",search:s="",minProfit:a="0",maxInvestment:o,sortBy:u="popularity"}=r||{},l=parseFloat(a),m=o?parseFloat(o):null,d={status:!0};"trending"===i&&(d.trending=!0);s&&(d[sequelize_1.Op.or]=[{title:{[sequelize_1.Op.like]:`%${s}%`}},{description:{[sequelize_1.Op.like]:`%${s}%`}}]);l>0&&(d.minProfit={[sequelize_1.Op.gte]:l});null!==m&&(d[sequelize_1.Op.and]=[(0,sequelize_1.literal)(`COALESCE(\`forexPlan\`.\`maxAmount\`, 100000) <= ${m}`)]);const p=db_1.sequelize,c=[];"profit"===u?c.push(["profitPercentage","DESC"]):"minInvestment"===u?c.push(["minAmount","ASC"]):c.push([p.literal("invested"),"DESC"]);const y=await db_1.models.forexPlan.findAll({attributes:{exclude:["defaultProfit","defaultResult","deletedAt","status"],include:[[p.fn("COALESCE",p.fn("SUM",p.col("investments.amount")),0),"invested"]]},where:d,include:[{model:db_1.models.forexInvestment,as:"investments",attributes:[]}],group:["forexPlan.id"],order:c});null==n||n.success("Request completed successfully");return y};