"use strict";function getWeekNumber(e){const t=new Date(Date.UTC(e.getFullYear(),e.getMonth(),e.getDate())),r=t.getUTCDay()||7;t.setUTCDate(t.getUTCDate()+4-r);const a=new Date(Date.UTC(t.getUTCFullYear(),0,1));return Math.ceil(((t.getTime()-a.getTime())/864e5+1)/7)}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Forex User Dashboard Data",description:"Retrieves user-specific dashboard data including overview statistics, chart data, plan distribution, and recent investments.",operationId:"getForexUserDashboardData",tags:["Forex","Dashboard","User"],requiresAuth:!0,logModule:"FOREX",logTitle:"Get Forex Overview",parameters:[{name:"timeframe",in:"query",description:"Timeframe for chart data: 1m, 3m, or 1y",required:!1,schema:{type:"string",enum:["1m","3m","1y"]}}],responses:{200:{description:"User dashboard data retrieved successfully.",content:{"application/json":{schema:{type:"object",properties:{overview:{type:"object",properties:{totalInvested:{type:"number"},totalProfit:{type:"number"},profitPercentage:{type:"number"},activeInvestments:{type:"number"},completedInvestments:{type:"number"}}},chartData:{type:"array",items:{type:"object",properties:{name:{type:"string"},value:{type:"number"}}}},planDistribution:{type:"array",items:{type:"object",properties:{name:{type:"string"},value:{type:"number"},percentage:{type:"number"}}}},recentInvestments:{type:"array",items:{type:"object",properties:{id:{type:"string"},plan:{type:"string"},amount:{type:"number"},createdAt:{type:"string",format:"date-time"},status:{type:"string"}}}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{user:t,query:r,ctx:a}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const s=t.id,{timeframe:n="1y"}=r,o=new Date;let i,l,u,d;if("1m"===n){i=new Date(o.getFullYear(),o.getMonth(),1);l=new Date(o.getFullYear(),o.getMonth()+1,0);u="%d";const e=l.getDate();d=Array.from({length:e},(e,t)=>(t+1).toString())}else if("3m"===n){i=new Date(o.getFullYear(),o.getMonth()-2,1);l=new Date(o.getFullYear(),o.getMonth()+1,0);u="%Y-%u";const e=[],t=new Date(i);for(;t<=l;){e.push(`${t.getFullYear()}-${getWeekNumber(t)}`);t.setDate(t.getDate()+7)}d=e}else{i=new Date(o.getFullYear(),0,1);l=new Date(o.getFullYear(),11,31);u="%b";d=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]}const p=await db_1.models.forexInvestment.findAll({where:{userId:s,status:{[sequelize_1.Op.ne]:"REJECTED"}},raw:!0}),m=p.reduce((e,t)=>e+(parseFloat(t.amount)||0),0),c=p.reduce((e,t)=>e+(parseFloat(t.profit)||0),0),g=m>0?c/m*100:0,b=p.filter(e=>"ACTIVE"===e.status).length,v=p.filter(e=>"COMPLETED"===e.status).length,y={totalInvested:m,totalProfit:c,profitPercentage:g,activeInvestments:b,completedInvestments:v},f=await db_1.models.forexInvestment.findAll({attributes:[[(0,sequelize_1.fn)("DATE_FORMAT",(0,sequelize_1.col)("createdAt"),u),"period"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalInvested"]],where:{userId:s,status:{[sequelize_1.Op.ne]:"REJECTED"},createdAt:{[sequelize_1.Op.between]:[i,l]}},group:["period"],raw:!0}),D={};f.forEach(e=>{D[e.period]=parseFloat(e.totalInvested)||0});const h=d.map(e=>({name:e,value:D[e]||0})),w=(await db_1.models.forexPlan.findAll({attributes:["name",[(0,sequelize_1.fn)("COALESCE",(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("investments.amount")),0),"totalInvested"]],include:[{model:db_1.models.forexInvestment,as:"investments",attributes:[],where:{userId:s,status:{[sequelize_1.Op.ne]:"REJECTED"}},required:!1}],group:["forexPlan.id"],raw:!0})).map(e=>{const t=parseFloat(e.totalInvested)||0,r=m>0?t/m*100:0;return{name:e.name,value:t,percentage:r}}),I=(await db_1.models.forexInvestment.findAll({where:{userId:s},order:[["createdAt","DESC"]],limit:5,raw:!0})).map(e=>({id:e.id,plan:e.planId,amount:e.amount,createdAt:e.createdAt,status:e.status}));null==a||a.success("Request completed successfully");return{overview:y,chartData:h,planDistribution:w,recentInvestments:I}};