"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),constants_1=require("@b/utils/constants"),query_1=require("@b/utils/query"),utils_1=require("../../admin/forex/investment/utils");exports.metadata={summary:"Lists user's Forex Investments with pagination and optional filtering",operationId:"listUserForexInvestments",tags:["Forex","Investments"],logModule:"FOREX",logTitle:"Get Forex Investments",parameters:constants_1.crudParameters,responses:{200:{description:"List of user's Forex Investments with pagination information",content:{"application/json":{schema:{type:"object",properties:{data:{type:"array",items:{type:"object",properties:utils_1.forexInvestmentSchema}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Forex Investments"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{query:t,user:r,ctx:s}=e;null==s||s.step("Fetching Forex Investments");if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==s||s.success("Get Forex Investments fetched successfully");return(0,query_1.getFiltered)({model:db_1.models.forexInvestment,query:t,where:{userId:r.id},sortField:t.sortField||"createdAt",includeModels:[{model:db_1.models.forexPlan,as:"plan",attributes:["id","name","title","description","profitPercentage","image"]},{model:db_1.models.forexDuration,as:"duration",attributes:["id","duration","timeframe"]}],numericFields:["amount","profit"]})};