"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Forex Investment Durations",description:"Retrieves a list of all available Forex investment durations, ordered by timeframe (HOUR, DAY, WEEK, MONTH) then duration ascending.",operationId:"getForexDurations",tags:["Forex","Duration"],logModule:"FOREX",logTitle:"Get Forex Durations",requiresAuth:!0,responses:{200:{description:"Forex investment durations retrieved successfully.",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string",description:"Duration ID"},duration:{type:"number",description:"Duration value"},timeframe:{type:"string",enum:["HOUR","DAY","WEEK","MONTH"],description:"Timeframe unit"}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{user:r,ctx:t}=e;null==t||t.step("Fetching Forex Durations");if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{const e="\n      CASE `forexDuration`.`timeframe`\n        WHEN 'HOUR' THEN 1\n        WHEN 'DAY' THEN 2\n        WHEN 'WEEK' THEN 3\n        WHEN 'MONTH' THEN 4\n      END\n    ",r=await db_1.models.forexDuration.findAll({attributes:["id","duration","timeframe"],order:[[(0,sequelize_1.literal)(e),"ASC"],["duration","ASC"]],raw:!0});null==t||t.success("Get Forex Durations fetched successfully");return r}catch(e){console.error("Error fetching durations:",e);throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error"})}};