"use strict";function validateEmail(a,i){var l,t,e,n;null===(l=null==i?void 0:i.step)||void 0===l||l.call(i,"Validating email address");const s=[];if(!a||"string"!=typeof a){s.push("Email is required");null===(t=null==i?void 0:i.fail)||void 0===t||t.call(i,"Email validation failed: Email is required");return{isValid:!1,errors:s}}const o=a.trim();validator_1.default.isEmail(o)||s.push("Invalid email format");o.length>254&&s.push("Email is too long");s.length>0?null===(e=null==i?void 0:i.fail)||void 0===e||e.call(i,`Email validation failed: ${s.join(", ")}`):null===(n=null==i?void 0:i.success)||void 0===n||n.call(i,"Email validation successful");return{isValid:0===s.length,errors:s}}function validateFAQQuestion(a,i){var l,t,e,n;null===(l=null==i?void 0:i.step)||void 0===l||l.call(i,"Validating FAQ question");const s=[];if(!a||"string"!=typeof a){s.push("Question is required");null===(t=null==i?void 0:i.fail)||void 0===t||t.call(i,"Question validation failed: Question is required");return{isValid:!1,errors:s}}const o=a.trim();o.length<10&&s.push("Question must be at least 10 characters long");o.length>500&&s.push("Question must not exceed 500 characters");s.length>0?null===(e=null==i?void 0:i.fail)||void 0===e||e.call(i,`Question validation failed: ${s.join(", ")}`):null===(n=null==i?void 0:i.success)||void 0===n||n.call(i,"Question validation successful");return{isValid:0===s.length,errors:s}}function validateFAQAnswer(a,i){var l,t,e,n;null===(l=null==i?void 0:i.step)||void 0===l||l.call(i,"Validating FAQ answer");const s=[];if(!a||"string"!=typeof a){s.push("Answer is required");null===(t=null==i?void 0:i.fail)||void 0===t||t.call(i,"Answer validation failed: Answer is required");return{isValid:!1,errors:s}}const o=a.trim();o.length<20&&s.push("Answer must be at least 20 characters long");o.length>1e4&&s.push("Answer must not exceed 10000 characters");s.length>0?null===(e=null==i?void 0:i.fail)||void 0===e||e.call(i,`Answer validation failed: ${s.join(", ")}`):null===(n=null==i?void 0:i.success)||void 0===n||n.call(i,"Answer validation successful");return{isValid:0===s.length,errors:s}}function validateCategory(a,i){var l,t,e,n;null===(l=null==i?void 0:i.step)||void 0===l||l.call(i,"Validating category name");const s=[];if(!a||"string"!=typeof a){s.push("Category is required");null===(t=null==i?void 0:i.fail)||void 0===t||t.call(i,"Category validation failed: Category is required");return{isValid:!1,errors:s}}const o=a.trim();o.length<2&&s.push("Category must be at least 2 characters long");o.length>50&&s.push("Category must not exceed 50 characters");/^[a-zA-Z0-9\s\-_]+$/.test(o)||s.push("Category contains invalid characters");s.length>0?null===(e=null==i?void 0:i.fail)||void 0===e||e.call(i,`Category validation failed: ${s.join(", ")}`):null===(n=null==i?void 0:i.success)||void 0===n||n.call(i,"Category validation successful");return{isValid:0===s.length,errors:s}}function validateTags(a,i){var l,t,e,n;null===(l=null==i?void 0:i.step)||void 0===l||l.call(i,"Validating tags array");const s=[];if(!Array.isArray(a)){s.push("Tags must be an array");null===(t=null==i?void 0:i.fail)||void 0===t||t.call(i,"Tags validation failed: Tags must be an array");return{isValid:!1,errors:s}}a.length>10&&s.push("Maximum 10 tags allowed");for(let i=0;i<a.length;i++){const l=a[i];if("string"!=typeof l){s.push(`Tag at index ${i} must be a string`);continue}const t=l.trim();t.length<2&&s.push(`Tag "${l}" must be at least 2 characters long`);t.length>30&&s.push(`Tag "${l}" must not exceed 30 characters`);/^[a-zA-Z0-9\s\-_]+$/.test(t)||s.push(`Tag "${l}" contains invalid characters`)}s.length>0?null===(e=null==i?void 0:i.fail)||void 0===e||e.call(i,`Tags validation failed: ${s.join(", ")}`):null===(n=null==i?void 0:i.success)||void 0===n||n.call(i,"Tags validation successful");return{isValid:0===s.length,errors:s}}function validateFeedbackComment(a,i){var l,t,e,n,s;null===(l=null==i?void 0:i.step)||void 0===l||l.call(i,"Validating feedback comment");const o=[];if(null==a){null===(t=null==i?void 0:i.success)||void 0===t||t.call(i,"Feedback comment validation successful (optional field)");return{isValid:!0,errors:[]}}if("string"!=typeof a){o.push("Comment must be a string");null===(e=null==i?void 0:i.fail)||void 0===e||e.call(i,"Comment validation failed: Comment must be a string");return{isValid:!1,errors:o}}a.length>1e3&&o.push("Comment must not exceed 1000 characters");o.length>0?null===(n=null==i?void 0:i.fail)||void 0===n||n.call(i,`Comment validation failed: ${o.join(", ")}`):null===(s=null==i?void 0:i.success)||void 0===s||s.call(i,"Comment validation successful");return{isValid:0===o.length,errors:o}}function validatePagePath(a,i){var l,t,e,n;null===(l=null==i?void 0:i.step)||void 0===l||l.call(i,"Validating page path");const s=[];if(!a||"string"!=typeof a){s.push("Page path is required");null===(t=null==i?void 0:i.fail)||void 0===t||t.call(i,"Page path validation failed: Page path is required");return{isValid:!1,errors:s}}const o=a.trim();o.startsWith("/")||s.push("Page path must start with /");o.length>200&&s.push("Page path must not exceed 200 characters");/^[a-zA-Z0-9\-_/]+$/.test(o)||s.push("Page path contains invalid characters");s.length>0?null===(e=null==i?void 0:i.fail)||void 0===e||e.call(i,`Page path validation failed: ${s.join(", ")}`):null===(n=null==i?void 0:i.success)||void 0===n||n.call(i,"Page path validation successful");return{isValid:0===s.length,errors:s}}function sanitizeInput(a,i){var l,t,e;null===(l=null==i?void 0:i.step)||void 0===l||l.call(i,"Sanitizing input string");if(!a||"string"!=typeof a){null===(t=null==i?void 0:i.success)||void 0===t||t.call(i,"Input sanitization complete (empty input)");return""}const n=validator_1.default.escape(a.trim());null===(e=null==i?void 0:i.success)||void 0===e||e.call(i,"Input sanitization successful");return n}function validateAndSanitizeFAQ(a,i){var l,t,e,n;null===(l=null==i?void 0:i.step)||void 0===l||l.call(i,"Starting FAQ data validation and sanitization");const s=[],o=validateFAQQuestion(a.question,i);o.isValid||s.push(...o.errors);const r=validateFAQAnswer(a.answer,i);r.isValid||s.push(...r.errors);const u=validateCategory(a.category,i);u.isValid||s.push(...u.errors);if(void 0!==a.tags){const l=validateTags(a.tags,i);l.isValid||s.push(...l.errors)}const d=validatePagePath(a.pagePath,i);d.isValid||s.push(...d.errors);if(s.length>0){null===(t=null==i?void 0:i.fail)||void 0===t||t.call(i,`FAQ validation failed with ${s.length} error(s)`);return{isValid:!1,errors:s}}null===(e=null==i?void 0:i.step)||void 0===e||e.call(i,"Sanitizing FAQ data");const c={question:sanitizeInput(a.question,i),answer:a.answer,category:sanitizeInput(a.category,i),tags:a.tags?a.tags.map(a=>sanitizeInput(a,i)):[],pagePath:sanitizeInput(a.pagePath,i),status:"boolean"!=typeof a.status||a.status,order:"number"==typeof a.order?a.order:0,image:a.image?sanitizeInput(a.image,i):void 0};null===(n=null==i?void 0:i.success)||void 0===n||n.call(i,"FAQ validation and sanitization completed successfully");return{isValid:!0,errors:[],sanitized:c}}var __importDefault=this&&this.__importDefault||function(a){return a&&a.__esModule?a:{default:a}};Object.defineProperty(exports,"__esModule",{value:!0});exports.validateEmail=validateEmail;exports.validateFAQQuestion=validateFAQQuestion;exports.validateFAQAnswer=validateFAQAnswer;exports.validateCategory=validateCategory;exports.validateTags=validateTags;exports.validateFeedbackComment=validateFeedbackComment;exports.validatePagePath=validatePagePath;exports.sanitizeInput=sanitizeInput;exports.validateAndSanitizeFAQ=validateAndSanitizeFAQ;const validator_1=__importDefault(require("validator"));