"use strict";function getCategoryIcon(e){if(!e)return"help-circle";return{account:"user",security:"shield",trading:"trending-up",wallet:"wallet",deposit:"plus-circle",withdrawal:"minus-circle",general:"help-circle",kyc:"id-card",payment:"credit-card",support:"headphones",verification:"check-circle",fees:"percent",api:"code",mobile:"smartphone"}[e.toLowerCase()]||"help-circle"}function getTimeAgo(e){const t=Math.floor((Date.now()-new Date(e).getTime())/1e3);return t<60?"just now":t<3600?`${Math.floor(t/60)}m ago`:t<86400?`${Math.floor(t/3600)}h ago`:t<604800?`${Math.floor(t/86400)}d ago`:`${Math.floor(t/604800)}w ago`}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize");exports.metadata={summary:"Get FAQ Statistics",description:"Retrieves statistics for the FAQ knowledge base including popular FAQs, trending searches, and category stats.",operationId:"getFAQStats",tags:["FAQ","Landing"],requiresAuth:!1,responses:{200:{description:"FAQ statistics retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{stats:{type:"object"},popularFaqs:{type:"array"},popularSearches:{type:"array"},categoriesWithStats:{type:"array"},recentQuestions:{type:"array"}}}}}}}};exports.default=async()=>{const e=new Date(Date.now()-6048e5),[t,s,a,r,o,i,l,u,n]=await Promise.all([db_1.models.faq.count({where:{status:!0}}),db_1.models.faq.findAll({where:{status:!0},attributes:[[(0,sequelize_1.fn)("DISTINCT",(0,sequelize_1.col)("category")),"category"]],raw:!0}),db_1.models.faq.sum("views",{where:{status:!0}}),db_1.models.faqFeedback.count({where:{isHelpful:!0}}),db_1.models.faqQuestion.count({where:{status:"ANSWERED"}}),db_1.models.faq.findAll({where:{status:!0},order:[["views","DESC"]],limit:6,include:[{model:db_1.models.faqFeedback,as:"feedbacks",attributes:["isHelpful"],required:!1}]}),db_1.models.faqSearch.findAll({where:{createdAt:{[sequelize_1.Op.gte]:e}},attributes:["query",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"count"],[(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("resultCount")),"avgResults"]],group:["query"],order:[[(0,sequelize_1.literal)("count"),"DESC"]],limit:10,raw:!0}),db_1.models.faqQuestion.findAll({order:[["createdAt","DESC"]],limit:5}),db_1.models.faq.findAll({where:{status:!0},attributes:["category",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"faqCount"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("views")),"totalViews"]],group:["category"],order:[[(0,sequelize_1.literal)("faqCount"),"DESC"]],raw:!0})]),c=i.map(e=>{const t=e.toJSON(),s=t.feedbacks||[],a=s.filter(e=>e.isHelpful).length,r=s.length;return{id:t.id,question:t.question,answer:t.answer&&"string"==typeof t.answer?t.answer.replace(/<[^>]*>/g,"").substring(0,150)+"...":"",category:t.category,views:t.views||0,helpfulCount:a,helpfulPercentage:r>0?Math.round(a/r*100):0}}),d=l.map(e=>({query:e.query,count:parseInt(e.count),hasResults:parseFloat(e.avgResults)>0})),p=l.filter(e=>0===parseFloat(e.avgResults)).slice(0,5).map(e=>({query:e.query,count:parseInt(e.count)})),f=n.map(e=>({name:e.category,faqCount:parseInt(e.faqCount),totalViews:parseInt(e.totalViews)||0,icon:getCategoryIcon(e.category)})),g=u.map(e=>({id:e.id,question:e.question.length>100?e.question.substring(0,100)+"...":e.question,status:e.status,createdAt:e.createdAt,timeAgo:getTimeAgo(e.createdAt)}));return{stats:{totalFaqs:t,totalCategories:s.length,totalViews:a||0,totalHelpfulVotes:r,questionsAnswered:o},popularFaqs:c,popularSearches:d.filter(e=>e.hasResults),categoriesWithStats:f,recentQuestions:g,unansweredSearches:p}};