"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Search FAQs and Record Query",description:"Searches FAQs based on query and category, and records the search for analytics.",operationId:"searchAndRecordFAQ",tags:["FAQ"],logModule:"FAQ",logTitle:"Search FAQs",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{userId:{type:"string"},query:{type:"string"},category:{type:"string"}},required:["query"]}}}},responses:{200:{description:"Search results returned",content:{"application/json":{schema:{type:"array",items:{type:"object"}}}}},400:{description:"Bad Request"},500:{description:"Internal Server Error"}},requiresAuth:!1};exports.default=async e=>{const{body:r,user:s,ctx:t}=e,{query:o,category:a}=r;null==t||t.step("Validating search query");if(!o||"string"!=typeof o){null==t||t.fail("Query is required");throw(0,error_1.createError)({statusCode:400,message:"Query is required"})}const i=o.trim().toLowerCase();if(i.length<2){null==t||t.fail("Query must be at least 2 characters");throw(0,error_1.createError)({statusCode:400,message:"Query must be at least 2 characters"})}try{null==t||t.step("Building search conditions");const e={status:!0,[sequelize_1.Op.or]:[{question:{[sequelize_1.Op.like]:`%${i}%`}},{answer:{[sequelize_1.Op.like]:`%${i}%`}}]};a&&"all"!==a&&(e.category=a);null==t||t.step(`Searching FAQs for query: "${i}"`);const o=await db_1.models.faq.findAll({where:e,order:[["order","ASC"]],limit:50});null==t||t.step("Recording search for analytics");const n=(null==s?void 0:s.id)||r.userId;(n||i.length>3)&&db_1.models.faqSearch.create({userId:n,query:i,resultCount:o.length,category:a}).catch(e=>{console.error("Error recording FAQ search:",e)});null==t||t.success(`Found ${o.length} FAQs matching query`);return o}catch(e){console.error("Error searching FAQs:",e);null==t||t.fail(e instanceof Error?e.message:"Failed to search FAQs");throw(0,error_1.createError)({statusCode:500,message:e instanceof Error?e.message:"Failed to search FAQs"})}};