"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),tokens_1=require("@b/api/(ext)/ecosystem/utils/tokens"),query_1=require("@b/utils/query");exports.metadata={summary:"Get maximum withdrawable amount",description:"Calculates the maximum amount that can be withdrawn for a given currency and chain",operationId:"getMaxWithdrawable",tags:["Wallet","Withdrawal"],requiresAuth:!0,logModule:"ECOSYSTEM",logTitle:"Calculate maximum withdrawal amount",parameters:[{name:"currency",in:"query",required:!0,schema:{type:"string"},description:"Currency code (e.g., BTC, ETH)"},{name:"chain",in:"query",required:!0,schema:{type:"string"},description:"Chain/network (e.g., BTC, ETH, BSC)"}],responses:{200:{description:"Maximum withdrawable amount calculated successfully",content:{"application/json":{schema:{type:"object",properties:{maxAmount:{type:"number",description:"Maximum amount that can be withdrawn"},platformFee:{type:"number",description:"Platform withdrawal fee"},estimatedNetworkFee:{type:"number",description:"Estimated network transaction fee (0 for UTXO chains until processing)"},isUtxoChain:{type:"boolean",description:"Whether this is a UTXO-based chain"},utxoInfo:{type:"object",description:"Additional UTXO information (only for BTC/LTC/DOGE/DASH)",properties:{utxoCount:{type:"number"},reason:{type:"string"}}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Wallet or Token"),500:query_1.serverErrorResponse}};exports.default=async e=>{var t,a,r,o,i,n;const{query:s,user:l,ctx:u}=e;if(!(null==l?void 0:l.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{currency:c,chain:d}=s;null==u||u.step("Validating request parameters");if(!c||!d){null==u||u.fail("Missing currency or chain parameter");throw(0,error_1.createError)({statusCode:400,message:"Currency and chain parameters are required"})}try{null==u||u.step(`Finding wallet for ${c}`);const e=await db_1.models.wallet.findOne({where:{userId:l.id,currency:c,type:"ECO"}});if(!e){null==u||u.fail(`Wallet not found for ${c}`);throw(0,error_1.createError)({statusCode:404,message:"Wallet not found"})}null==u||u.step(`Fetching token configuration for ${c} on ${d}`);const s=await(0,tokens_1.getEcosystemToken)(d,c);if(!s){null==u||u.fail(`Token not found for ${c} on ${d}`);throw(0,error_1.createError)({statusCode:404,message:"Token not found"})}null==u||u.step("Calculating available balance");let m=e.balance;const f=await db_1.models.walletData.findOne({where:{walletId:e.id,chain:d}});if(f){m=parseFloat(f.balance)||0;if("PERMIT"===s.contractType){const t=await db_1.models.ecosystemPrivateLedger.findOne({where:{walletId:e.id,index:f.index,currency:c,chain:d}});if(t&&t.offchainDifference){m-=parseFloat(t.offchainDifference)||0}}}null==u||u.step("Calculating platform fees");let p=0;if(s.fee){const e=JSON.parse(s.fee);t=e.percentage;p=null!==(a=e.min)&&void 0!==a?a:0}const h=["BTC","LTC","DOGE","DASH"].includes(d);let w=m-p,g=0,y=null;if(["ETH","BSC","POLYGON","FTM","OPTIMISM","ARBITRUM","BASE","CELO","RSK","AVAX"].includes(d)&&"NATIVE"===s.contractType)try{const e=require("ethers"),{initializeProvider:t}=require("@b/blockchains/evm"),a=await t(d),i=await a.getFeeData(),n=21e3,l=BigInt(n)*(i.gasPrice||i.maxFeePerGas||BigInt(0));g=parseFloat(e.formatUnits(l,s.decimals));w-=g;console.log("[MAX_WITHDRAW] NATIVE EVM gas estimation:",{chain:d,gasLimit:n,gasPrice:(null===(r=i.gasPrice)||void 0===r?void 0:r.toString())||(null===(o=i.maxFeePerGas)||void 0===o?void 0:o.toString()),estimatedNetworkFee:g,availableBalance:m,platformFee:p,maxAmountAfterFees:w})}catch(e){console.error("[MAX_WITHDRAW] Error estimating EVM gas:",e.message);g=1e-4;w-=g}if(h&&w>0){const{calculateMinimumWithdrawal:t}=require("@b/api/(ext)/ecosystem/utils/utxo");try{let a,r=w,o=0,i=w,n=0,s=null;for(let l=0;l<20;l++){r=(o+i)/2;if(r<=0)break;a=await t(e.id,d,r);if(a.isEconomical){n=r;s=a;o=r}else i=r;if(Math.abs(i-o)<1e-8)break}if(s&&s.utxoCount){w=n;y={utxoCount:s.utxoCount,reason:s.reason};g=m-p-w}else{w=0;const a=await t(e.id,d,1e-8);y={utxoCount:(null==a?void 0:a.utxoCount)||0,reason:(null==a?void 0:a.reason)||"Insufficient funds for any withdrawal"}}}catch(e){console.error("[MAX_WITHDRAW] Error calculating UTXO max:",e.message);w=Math.max(0,m-p)}}w=Math.max(0,w);null==u||u.step("Formatting result");const x=null!==(n=null!==(i=s.precision)&&void 0!==i?i:s.decimals)&&void 0!==n?n:8;w=parseFloat(w.toFixed(x));p=parseFloat(p.toFixed(x));g=parseFloat(g.toFixed(x));null==u||u.success(`Max withdrawable: ${w} ${c} (platform fee: ${p}, network fee: ${g})`);return{maxAmount:w,platformFee:p,estimatedNetworkFee:g,isUtxoChain:h,utxoInfo:y}}catch(e){console.error("[MAX_WITHDRAW] Error:",e);null==u||u.fail(`Failed to calculate max withdrawal: ${e.message}`);throw(0,error_1.createError)({statusCode:500,message:`Failed to calculate maximum withdrawable amount: ${e.message}`})}};