"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),utils_1=require("./utils");exports.metadata={summary:"Lists all wallets for the logged-in user",description:"Retrieves all wallets associated with the logged-in user, optionally including transactions and address.",operationId:"listWallets",tags:["Wallet","User"],logModule:"ECOSYSTEM",logTitle:"List user wallets",parameters:[{name:"transactions",in:"query",schema:{type:"boolean",default:!1},description:"Whether to include transaction details"},{name:"address",in:"query",schema:{type:"boolean",default:!1},description:"Whether to include wallet address"}],responses:{200:{description:"Wallets retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:utils_1.baseWalletSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Wallet"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:t,query:s,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{transactions:a,address:l}=s;try{null==r||r.step("Building query parameters");const e=[];"true"===a&&e.push({model:db_1.models.transaction,as:"transactions",attributes:["id","type","status","amount","fee","description","metadata","referenceId","createdAt"]});const s=["id","type","currency","balance"];"true"===l&&s.push("address");null==r||r.step("Fetching user wallets");const i=await db_1.models.wallet.findAll({where:{userId:t.id,type:"ECO"},include:e,attributes:s});null==r||r.success(`Retrieved ${(null==i?void 0:i.length)||0} wallets`);return i}catch(e){null==r||r.fail(`Failed to fetch wallets: ${e.message}`);throw(0,error_1.createError)({statusCode:500,message:`Failed to fetch wallets: ${e.message}`})}};