"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.GenericUTXONodeService=void 0;const console_1=require("@b/utils/console"),error_1=require("@b/utils/error");class GenericUTXONodeService{constructor(e){const t=e.toLowerCase();this.config={host:process.env[`${e}_NODE_HOST`]||"127.0.0.1",port:parseInt(process.env[`${e}_NODE_PORT`]||this.getDefaultPort(e)),username:process.env[`${e}_NODE_USER`]||"",password:process.env[`${e}_NODE_PASSWORD`]||"",chain:e,walletName:`ecosystem_${t}_wallets`};this.rpcUrl=`http://${this.config.host}:${this.config.port}`}getDefaultPort(e){return{BTC:"8332",LTC:"9332",DOGE:"22555",DASH:"9998"}[e]||"8332"}async initialize(){console_1.logger.info(`${this.config.chain}_NODE`,`Initializing ${this.config.chain} Core RPC connection`);try{const e=await this.rpcCall("getblockchaininfo",[]);console_1.logger.success(`${this.config.chain}_NODE`,`Connected - Blocks: ${e.blocks}, Chain: ${e.chain}`);await this.ensureWalletExists()}catch(e){console_1.logger.error(`${this.config.chain}_NODE`,`Failed to initialize: ${e.message}`);throw e}}async ensureWalletExists(){try{await this.rpcCall("loadwallet",[this.config.walletName]);console_1.logger.info(`${this.config.chain}_NODE`,`Loaded existing wallet: ${this.config.walletName}`)}catch(e){if(e.message.includes("not found")||e.message.includes("does not exist"))try{await this.rpcCall("createwallet",[this.config.walletName,!1,!1,"",!1,!0,!1]);console_1.logger.success(`${this.config.chain}_NODE`,`Created new watch-only wallet: ${this.config.walletName}`)}catch(e){if(e.message.includes("descriptors")){await this.rpcCall("createwallet",[this.config.walletName,!1,!1,"",!1]);console_1.logger.success(`${this.config.chain}_NODE`,`Created wallet (legacy mode): ${this.config.walletName}`)}else console_1.logger.error(`${this.config.chain}_NODE`,`Failed to create wallet: ${e.message}`)}else{if(!e.message.includes("already loaded"))throw e;console_1.logger.info(`${this.config.chain}_NODE`,`Wallet already loaded: ${this.config.walletName}`)}}}async rpcCall(e,t=[]){const a=Buffer.from(`${this.config.username}:${this.config.password}`).toString("base64");try{const o=await fetch(this.rpcUrl,{method:"POST",headers:{"Content-Type":"application/json",Authorization:`Basic ${a}`},body:JSON.stringify({jsonrpc:"1.0",id:Date.now(),method:e,params:t})}),r=await o.json();if(r.error)throw(0,error_1.createError)({statusCode:500,message:r.error.message||"RPC call failed"});return r.result}catch(e){console_1.logger.error(`${this.config.chain}_NODE`,"RPC call failed",e);throw e}}async walletRpcCall(e,t=[]){const a=Buffer.from(`${this.config.username}:${this.config.password}`).toString("base64"),o=`${this.rpcUrl}/wallet/${this.config.walletName}`;try{const r=await fetch(o,{method:"POST",headers:{"Content-Type":"application/json",Authorization:`Basic ${a}`},body:JSON.stringify({jsonrpc:"1.0",id:Date.now(),method:e,params:t})}),s=await r.json();if(s.error)throw(0,error_1.createError)({statusCode:500,message:s.error.message||"Wallet RPC call failed"});return s.result}catch(e){console_1.logger.error(`${this.config.chain}_NODE`,"Wallet RPC call failed",e);throw e}}async importAddress(e,t=""){try{console_1.logger.debug(`${this.config.chain}_NODE`,`Importing address ${e}`);await this.walletRpcCall("importaddress",[e,t,!1]);console_1.logger.info(`${this.config.chain}_NODE`,`Successfully imported address ${e}`)}catch(t){if(!t.message.includes("already have this key"))throw t;console_1.logger.debug(`${this.config.chain}_NODE`,`Address ${e} already imported`)}}async getAddressTransactions(e){try{const t=await this.walletRpcCall("listtransactions",["*",100,0,!0]);return t.filter(t=>t.address===e)}catch(t){console_1.logger.error(`${this.config.chain}_NODE`,`Failed to get transactions for ${e}: ${t.message}`);throw t}}async getAddressBalance(e){try{const t=await this.walletRpcCall("listunspent",[0,9999999,[e]]);return t.reduce((e,t)=>e+t.amount,0)}catch(t){console_1.logger.error(`${this.config.chain}_NODE`,`Failed to get balance for ${e}: ${t.message}`);return 0}}async listUnspent(e,t=1){try{return await this.walletRpcCall("listunspent",[t,9999999,[e]])}catch(t){console_1.logger.error(`${this.config.chain}_NODE`,`Failed to list unspent for ${e}: ${t.message}`);return[]}}async getBlockchainInfo(){return await this.rpcCall("getblockchaininfo",[])}async getRawTransaction(e,t=!0){try{return await this.rpcCall("getrawtransaction",[e,t])}catch(t){console_1.logger.error(`${this.config.chain}_NODE`,`Failed to get raw transaction ${e}: ${t.message}`);throw t}}async decodeRawTransaction(e){try{return await this.rpcCall("decoderawtransaction",[e])}catch(e){console_1.logger.error(`${this.config.chain}_NODE`,`Failed to decode raw transaction: ${e.message}`);throw e}}async sendRawTransaction(e){try{const t=await this.rpcCall("sendrawtransaction",[e]);console_1.logger.success(`${this.config.chain}_NODE`,`Transaction broadcasted: ${t}`);return t}catch(e){console_1.logger.error(`${this.config.chain}_NODE`,`Failed to broadcast transaction: ${e.message}`);throw e}}async estimateSmartFee(e){try{return await this.rpcCall("estimatesmartfee",[e])}catch(e){console_1.logger.error(`${this.config.chain}_NODE`,`Failed to estimate fee: ${e.message}`);return{}}}async getMempoolInfo(){try{return await this.rpcCall("getmempoolinfo",[])}catch(e){console_1.logger.error(`${this.config.chain}_NODE`,`Failed to get mempool info: ${e.message}`);return null}}async getRawMempool(e=!1){try{return await this.rpcCall("getrawmempool",[e])}catch(t){return e?{}:[]}}async getMempoolEntry(e){try{return await this.rpcCall("getmempoolentry",[e])}catch(e){return null}}async bumpFee(e,t){try{console_1.logger.info(`${this.config.chain}_NODE`,`Bumping fee for transaction ${e}`);const a={};(null==t?void 0:t.confTarget)&&(a.conf_target=t.confTarget);(null==t?void 0:t.feeRate)&&(a.fee_rate=t.feeRate);const o=await this.walletRpcCall("bumpfee",[e,a]);console_1.logger.success(`${this.config.chain}_NODE`,`Fee bumped successfully: newTxid=${o.txid}, originalFee=${o.origfee}, newFee=${o.fee}`);return o}catch(t){console_1.logger.error(`${this.config.chain}_NODE`,`Failed to bump fee for ${e}: ${t.message}`);throw t}}async isRBFSignaled(e){try{const t=await this.getRawTransaction(e,!0);if(!t)return!1;for(const e of t.vin)if(e.sequence<4294967294)return!0;return!1}catch(e){return!1}}async abandonTransaction(e){try{console_1.logger.info(`${this.config.chain}_NODE`,`Abandoning transaction ${e}`);await this.walletRpcCall("abandontransaction",[e]);console_1.logger.success(`${this.config.chain}_NODE`,`Transaction ${e} abandoned successfully`)}catch(t){console_1.logger.error(`${this.config.chain}_NODE`,`Failed to abandon transaction ${e}: ${t.message}`);throw t}}async isSynced(){try{const e=await this.getBlockchainInfo();return e.blocks>=e.headers-1}catch(e){return!1}}async getSyncProgress(){try{const e=await this.getBlockchainInfo();return{blocks:e.blocks,headers:e.headers,progress:e.blocks/e.headers*100}}catch(e){return{blocks:0,headers:0,progress:0}}}async getTransactionStatus(e){try{const t=await this.getRawTransaction(e,!0);if(t&&t.confirmations>0)return{confirmed:!0,confirmations:t.confirmations,inMempool:!1};const a=await this.getMempoolEntry(e);return a?{confirmed:!1,confirmations:0,inMempool:!0,mempoolInfo:a}:{confirmed:!1,confirmations:0,inMempool:!1}}catch(e){return{confirmed:!1,confirmations:0,inMempool:!1}}}getChain(){return this.config.chain}getConfig(){return{...this.config}}}exports.GenericUTXONodeService=GenericUTXONodeService;exports.default=GenericUTXONodeService;