"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.fetchPublicEcosystemTransactions=exports.fetchGeneralEcosystemTransactions=exports.fetchEcosystemTransactions=void 0;const date_fns_1=require("date-fns"),chains_1=require("./chains"),utxo_1=require("./utxo"),redis_1=require("../../../../utils/redis"),console_1=require("@b/utils/console"),safe_imports_1=require("@b/utils/safe-imports"),error_1=require("@b/utils/error"),CACHE_EXPIRATION=30,fetchEcosystemTransactions=async(e,t)=>{const s=chains_1.chainConfigs[e];if(!s)throw(0,error_1.createError)({statusCode:400,message:`Unsupported chain: ${e}`});try{if(["BTC","LTC","DOGE","DASH"].includes(e))return await(0,utxo_1.fetchUTXOTransactions)(e,t);if("SOL"===e){const e=await(0,safe_imports_1.getSolanaService)(),s=await e.getInstance();return await s.fetchTransactions(t)}if("TRON"===e){const e=await(0,safe_imports_1.getTronService)(),s=await e.getInstance();return await s.fetchTransactions(t)}if("XMR"===e){const e=await(0,safe_imports_1.getMoneroService)(),t=await e.getInstance();return await t.fetchTransactions("master_wallet")}if("TON"===e){const e=await(0,safe_imports_1.getTonService)(),s=await e.getInstance();return await s.fetchTransactions(t)}return await fetchAndParseTransactions(t,e,s)}catch(e){console_1.logger.error("ECOSYSTEM_TRANSACTIONS","Failed to fetch ecosystem transactions",e);throw(0,error_1.createError)({statusCode:500,message:e.message})}};exports.fetchEcosystemTransactions=fetchEcosystemTransactions;const fetchAndParseTransactions=async(e,t,s)=>{const r=`wallet:${e}:transactions:${t.toLowerCase()}`;if(s.cache){const e=await getCachedData(r);if(e)return e}const a=await s.fetchFunction(e,t),o=parseRawTransactions(a);if(s.cache){const e={transactions:o,timestamp:(new Date).toISOString()},t=redis_1.RedisSingleton.getInstance();await t.setex(r,30,JSON.stringify(e))}return o},getCachedData=async e=>{const t=redis_1.RedisSingleton.getInstance();let s=await t.get(e);s&&"string"==typeof s&&(s=JSON.parse(s));if(s){const e=new Date,t=new Date(s.timestamp);if((0,date_fns_1.differenceInMinutes)(e,t)<30)return s.transactions}return null},parseRawTransactions=e=>{if(!Array.isArray(null==e?void 0:e.result)){console_1.logger.error("TRANSACTIONS","Invalid raw transactions format received",{type:typeof e,isArray:Array.isArray(e),hasResult:null==e?void 0:e.hasOwnProperty("result"),resultType:typeof(null==e?void 0:e.result),keys:e?Object.keys(e):"null",sample:JSON.stringify(e).substring(0,500)});throw(0,error_1.createError)({statusCode:500,message:"Invalid raw transactions format: expected {result: array}, got "+typeof e})}return e.result.map(e=>({timestamp:e.timeStamp,hash:e.hash,from:e.from,to:e.to,amount:e.value,method:e.functionName,methodId:e.methodId,contract:e.contractAddress,confirmations:e.confirmations,status:e.txreceipt_status,isError:e.isError,gas:e.gas,gasPrice:e.gasPrice,gasUsed:e.gasUsed}))},fetchGeneralEcosystemTransactions=async(e,t)=>{var s;const r=chains_1.chainConfigs[e];if(!r)throw(0,error_1.createError)({statusCode:400,message:`Unsupported chain: ${e}`});const a=`${e}_NETWORK`,o=process.env[a];if(!o)throw(0,error_1.createError)({statusCode:500,message:`Environment variable ${a} is not set`});const n=null===(s=r.explorerApi)||void 0===s||s,i=process.env.ETHERSCAN_API_KEY||process.env[`${e}_EXPLORER_API_KEY`];if(n&&!i)throw(0,error_1.createError)({statusCode:500,message:`Environment variable ETHERSCAN_API_KEY or ${e}_EXPLORER_API_KEY is not set`});const c=r.networks[o];if(!c||!c.chainId)throw(0,error_1.createError)({statusCode:500,message:`Unsupported or misconfigured network: ${o} for chain: ${e}. ChainId is required for V2 API.`});const l=`https://api.etherscan.io/v2/api?chainid=${c.chainId}&module=account&action=txlist&address=${t}&startblock=0&endblock=99999999&sort=desc${n?`&apikey=${i}`:""}`;try{console_1.logger.info("ETHERSCAN",`${e} Fetching transactions for address ${t.substring(0,10)}... using chainId ${c.chainId}`);const s=await fetch(l);if(!s.ok){const e=s.statusText||"Unknown error",t=await s.text();throw(0,error_1.createError)({statusCode:s.status,message:`HTTP ${s.status} ${e}: ${t.substring(0,200)}`})}const r=s.headers.get("content-type");if(r&&r.includes("text/html")){const e=await s.text();throw(0,error_1.createError)({statusCode:502,message:`Received HTML instead of JSON. API might be down or rate limited. Response: ${e.substring(0,200)}`})}const a=await s.json();if("0"===a.status&&"NOTOK"===a.message){console_1.logger.warn("ETHERSCAN",`${e} API error: ${a.result}`);return{status:"1",message:"OK",result:[]}}if(!a.result||!Array.isArray(a.result)){console_1.logger.warn("ETHERSCAN",`${e} Unexpected response format, returning empty results`);return{status:"1",message:"OK",result:[]}}console_1.logger.info("ETHERSCAN",`${e} Successfully fetched ${a.result.length} transactions`);return a}catch(e){console_1.logger.error("GENERAL_TRANSACTIONS","API call failed",e);throw(0,error_1.createError)({statusCode:500,message:`API call failed: ${e.message}`})}};exports.fetchGeneralEcosystemTransactions=fetchGeneralEcosystemTransactions;const fetchPublicEcosystemTransactions=async e=>{try{const t=await fetch(e);return await t.json()}catch(e){console_1.logger.error("PUBLIC_TRANSACTIONS","API call failed",e);throw(0,error_1.createError)({statusCode:500,message:`API call failed: ${e.message}`})}};exports.fetchPublicEcosystemTransactions=fetchPublicEcosystemTransactions;